/*
 * @Author: 吴文洁 
 * @Date: 2020-06-09 09:47:21 
 * @Last Modified by: 吴文洁
 * @Last Modified time: 2020-06-23 14:54:14
 * @Description: 网络磁盘（我的文件、公共文件、员工文件）
 */
import React from 'react';

function DiskList(props) {
  
  const { diskList, currentRootDisk } = props;

  return (
    <div className="disk-list__wrap">
      <div className="disk-list">
        {
          diskList.map((item) => {

            const isActive = item.disk === currentRootDisk.disk;
            
            return (
              <div
                key={item.disk}
                className={`item ${isActive ? 'active' : ''}`}
                onClick={()  => { props.onChange(item)}}
              >
                {
                  item.disk === 'MYSELF' &&
                  <span className="icon iconfont">&#xe7a5;</span>
                }
                {
                  item.disk === 'COMMON' &&
                  <span className="icon iconfont">&#xe79d;</span>
                }
                {
                  item.disk === 'EMPLOYEE' && 
                  <span className="icon iconfont">&#xe7a3;</span>
                }
                <span className="disk-name">{ item.folderName }</span>
              </div>
            )
          })
        }
      </div>
    </div>
  )
};

export default DiskList;