/*
 * @Author: wufan
 * @Date: 2020-11-27 16:21:49
 * @LastEditors: zhangleyuan
 * @LastEditTime: 2021-02-01 14:02:23
 * @Description: Description
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React, { useState, useEffect } from "react";
import { Modal,Form,Input,Button,message} from "antd";
import './CatalogAddOrEditModal.less'
import User from '@/common/js/user';
import StoreService from "@/domains/store-domain/storeService";
interface CatalogAddOrEditModalProps {
  onClose:any;
  modalType:string
  refreshCatalogList:any;
  choosedItem:any;
}

function CatalogAddOrEditModal(props: CatalogAddOrEditModalProps) {
  const {onClose,modalType,refreshCatalogList,choosedItem} = props;
 
  const [catalogName,setCatalogName] = useState(choosedItem.categoryName);
  const [clickStatus,setClickStatus] = useState(false);
  useEffect(() => {
  });
  function handleConfirm(){
    if (clickStatus) {
      return;
    }
    setClickStatus(true);
    setTimeout(() => {
      setClickStatus(false);
    }, 1000);
    
    if(modalType === "add"){
      addCatalog();
    }else{
      editCatalog();
    }
  }
  function addCatalog():any{
    const param = {
      storeId: User.getStoreId(),
      categoryName:catalogName
    }
    StoreService.addCourseCategory(param).then((res: any) => {
      refreshCatalogList();
      onClose();
      message.success("添加分类成功");
    });
  }
  function editCatalog():any{
    const param = {
      categoryId:choosedItem.id,
      categoryName: catalogName,
    }
    StoreService.editCourseCategory(param).then((res: any) => {
      refreshCatalogList();
      onClose();
      message.success("编辑分类成功");
    });
  }
  return (
    <Modal
      visible={true}
      title={modalType === "add" ? '添加分类' : '编辑分类' }
      className="catalog-add-edit-modal"
      onCancel={onClose}
      width={448}
      footer={[
        <Button
            id='cancel_allot_btn'
            key="back" onClick={onClose}>取消</Button>,
        <Button
            id='confirm_allot_btn'
            key="submit"
            type="primary"
            onClick={() => {
                handleConfirm()
            }}>
            保存
        </Button>
      ]}
      maskClosable={false}
      closeIcon={<span className="icon iconfont modal-close-icon">&#xe6ef;</span>}
    >
     <Form
        labelCol={ {span:5 }}
     >
       <Form.Item
            label="分类名称"
            name="分类名称"
            rules={[{ required: true}]}
        >
        <Input type="text" placeholder="请输入分类名称，最多10个字" maxLength={10} style={{ width: 240 }}  
              defaultValue={catalogName}
              onChange={(e) => { 
              setCatalogName(e.target.value);
        }} />
      </Form.Item>
     </Form>
    </Modal>
  );
}

export default CatalogAddOrEditModal;
