import React, {  useEffect, useState} from "react";
import { Modal, Button, InputNumber, message  } from 'antd';
import "./BatchScore.less"
import _ from "underscore";

interface Rule {
    typeKey: "GAP_FILLING"|"INDEFINITE_CHOICE"| "JUDGE"|"MULTI_CHOICE"|"SINGLE_CHOICE",
    score: number,
    portionScore: number,
    totalQuestion: number,
}

interface BatchScoreProps {
    visible:boolean,
    rules: Rule[],
    onOK: (rules:Rule[]) => void,
    onCancel: () => void,
}

export default function BatchScore(props:BatchScoreProps) {
    
    const [rules, setRules] = useState<Rule[]>(_.sortBy(props.rules,"typeKey"))
    const [singleCount, setSingleCount] = useState<number[]>([0])
    const [multiCount, setMultiCount] = useState<number[]>([0])
    const [judgeCount, setJudgeCount] = useState<number[]>([0])
    const [gapCount, setgapCount] = useState<number[]>([0])
    const [indefiniteCount, setIndefiniteCount] = useState<number[]>([0])

    useEffect(()=> {
        _.map(props.rules,(item)=> {
            //更新分数统计
            switch(item.typeKey) {
              case "SINGLE_CHOICE":
                setSingleCount([item.totalQuestion,item.totalQuestion*item.score])
                break;
              case "MULTI_CHOICE":
                setMultiCount([item.totalQuestion,item.totalQuestion*item.score])
                break;
              case "JUDGE":
                setJudgeCount([item.totalQuestion,item.totalQuestion*item.score])
                break;
              case "GAP_FILLING":
                setgapCount([item.totalQuestion,item.totalQuestion*item.score])
                break;
              case "INDEFINITE_CHOICE":
                setIndefiniteCount([item.totalQuestion,item.totalQuestion*item.score])
                break;
              default:
                break;
            }
        })
    },[props.rules,rules])

    if (!props.visible) {
        return ("")
    }

    function onOk() {
        for (let i = 0;i < rules.length;++i) {
            if (rules[i].score <= 0 || rules[i].score > 100) {
                message.error("分值设置错误")
                return;
            }
        }
        props.onOK(rules)
    }

    function onCancel() {
        props.onCancel()
    }

    const inputNumberStyle = {width:"57px",margin:"0 8px"}
    return (
        <Modal 
        className="batchscore"
        title="批量设置分数"
        onCancel={onCancel}
        onOk={onOk}
        visible={props.visible}
        maskClosable={false}
        width={660}
        >
            <div className="content">
            <div className="item">
                <span className="type">【单选题】</span>
                <span className="score">每题
                <InputNumber 
                min={1} 
                max={100}
                value={rules[4].score}
                defaultValue={rules[4].score} 
                style={inputNumberStyle} 
                onChange={(v)=> {
                    v = Math.round(v)
                    let _rules = [...rules]
                    rules[4].score = v
                    setRules(_rules)
                }}
                />
                分</span>
                <span className="total">共<span style={{color:"#2966FF"}}>{singleCount[0]}</span>题，合计<span style={{color:"#2966FF"}}>{singleCount[1]}</span>分</span>
            </div>
            <div className="item">
                <span className="type">【多选题】</span>
                <span className="score">每题
                <InputNumber 
                min={1} 
                max={100}
                defaultValue={rules[3].score} 
                value={rules[3].score}
                style={inputNumberStyle} 
                onChange={(v)=> {
                    v = Math.round(v)
                    if (v <= rules[3].portionScore) {
                        return
                    }
                    let _r = [...rules]
                    _r[3].score = v
                    setRules(_r)
                }}
                />
                分，漏选得
                <InputNumber 
                min={0} 
                max={rules[3].score <= 0 ? 0 : rules[3].score-1}
                defaultValue={rules[3].portionScore} 
                value={rules[3].portionScore}
                style={inputNumberStyle} 
                onChange={(v)=> {
                    v = Math.round(v)
                    let _r = [...rules]
                    _r[3].portionScore = v
                    setRules(_r)
                }}
                />
                分</span>
                <span className="total">共<span style={{color:"#2966FF"}}>{multiCount[0]}</span>题，合计<span style={{color:"#2966FF"}}>{multiCount[1]}</span>分</span>
            </div>
            <div className="item">
                <span className="type">【不定项选择题】</span>
                <span className="score">每题
                <InputNumber 
                min={1} 
                max={100}
                defaultValue={rules[1].score} 
                value={rules[1].score}
                style={inputNumberStyle} 
                onChange={(v)=> {
                    v = Math.round(v)
                    if (v <= rules[1].portionScore) {
                        return
                    }
                    let _r = [...rules]
                    _r[1].score = v
                    setRules(_r)
                }}
                />
                分，漏选得
                <InputNumber 
                min={0} 
                max={rules[1].score <= 0 ? 0 : rules[1].score-1}
                defaultValue={rules[1].portionScore} 
                value={rules[1].portionScore} 
                style={inputNumberStyle} 
                onChange={(v)=> {
                    v = Math.round(v)
                    let _r = [...rules]
                    _r[1].portionScore = v
                    setRules(_r)
                }}
                />分</span>
                <span className="total">共<span style={{color:"#2966FF"}}>{indefiniteCount[0]}</span>题，合计<span style={{color:"#2966FF"}}>{indefiniteCount[1]}</span>分</span>
            </div>
            <div className="item">
                <span className="type">【判断题】</span>
                <span className="score">每题
                <InputNumber 
                min={1} 
                max={100}
                defaultValue={rules[2].score} 
                value={rules[2].score}
                style={inputNumberStyle} 
                onChange={(v)=> {
                    v = Math.round(v)
                    let _r = [...rules]
                    _r[2].score = v
                    setRules(_r)
                }}
                />
                分</span>
                <span className="total">共<span style={{color:"#2966FF"}}>{judgeCount[0]}</span>题，合计<span style={{color:"#2966FF"}}>{judgeCount[1]}</span>分</span>
            </div>
            <div className="item">
                <span className="type">【填空题】</span>
                <span className="score">每题
                <InputNumber 
                min={1} 
                max={100}
                defaultValue={rules[0].score} 
                value={rules[0].score}
                style={inputNumberStyle} 
                onChange={(v)=> {
                    v = Math.round(v)
                    if (v <= rules[0].portionScore) {
                        return
                    }
                    let _r = [...rules]
                    _r[0].score = v
                    setRules(_r)
                }}
                />
                分，半对得<InputNumber 
                min={0} 
                max={rules[0].score <= 0 ? 0 : rules[0].score-1}
                defaultValue={rules[0].portionScore} 
                value={rules[0].portionScore}
                style={inputNumberStyle} 
                onChange={(v)=> {
                    v = Math.round(v)
                    let _r = [...rules]
                    _r[0].portionScore = v
                    setRules(_r)
                }}
                />
                分</span>
                <span className="total">共<span style={{color:"#2966FF"}}>{gapCount[0]}</span>题，合计<span style={{color:"#2966FF"}}>{gapCount[1]}</span>分</span>
            </div>
            </div>

        </Modal>
    )
}