/*
 * @Author: zhangleyuan
 * @Date: 2021-02-20 16:45:51
 * @LastEditors: zhangleyuan
 * @LastEditTime: 2021-02-22 18:21:13
 * @Description: 描述一下
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React from 'react';
import { Button,Input,Switch,Radio,Row,Col} from 'antd';
import { withRouter } from 'react-router-dom';
import './BasicInfo.less';
const { TextArea } = Input;

function BasicInfo() {
  return (
    <div className="plan-basic-info">
        <div className="plan-name">
            <span className="label"><span className="require">*</span>课程名称：</span>
            <Input
                placeholder="请输入培训计划名称,最多20字"
                maxLength={20}
                style={{ width: 240 }}
            />    
        </div>
        <div className="cover">
          <span className="label">封面图：</span>
          <div className="cover__wrap">
            <div className="img-content">
              <span className="tag">默认图</span>
              <img src='https://image.xiaomaiketang.com/xm/YNfi45JwFA.png' width="690"/>
            </div>
            <div className="opt-btns">
              <Button>上传图片</Button>
              <span
                className={`default-btn disabled`}
              >使用默认图</span>
              <div className="tips">建议尺寸690*398像素，图片支持jpg、jpeg、png格式。</div>
            </div>
          </div>
        </div>
        <div className="introduction">
            <span className="label">简介：</span>
            <TextArea
              placeholder="请输入培训计划简介"
              maxLength={200}
              style={{ width: 480 }}
              className="instro-textarea"
            />
        </div>
        <div className="wether-use">
          <span className="label">是否启用：</span>
          <div className="content">
            <div>
                <Switch checked={true} />
            </div>  
            <div>
              <div className="instro-text">
                <div>开启：此培训计划可以分享给用户进行学习</div>
                <div>关闭：此培训计划暂不可分享给用户进行学习，后续可开启</div>
              </div>
            </div> 
          </div>
        </div>
        <div className="view-range" >
          <span className="label"><span className="require">*</span>可见范围：</span>
          <div className="content">
            <Radio.Group >
              <Row style={{ marginBottom: '5px' }}>
                <Col span={24}>
                  <Radio value="YES">
                    所有运营师 
                    <span className="playback__text">后续新增的运营师都有权限可见</span>
                  </Radio>
                </Col>
              </Row>
              <Row>
                <Col span={8}>
                  <Radio value="NO">
                    指定运营师
                    <span className="playback__text">仅被选择的运营师有权限可见</span>
                  </Radio>
                </Col>
              </Row>
            </Radio.Group>
            <div className="choose-business">
                <Button>选择运营师</Button>
                <span>已选择<span>0</span>名运营师</span>
            </div>
          </div>
        </div>
        <div className="done-standard">
            <span className="label"><span className="require">*</span>完成标准：</span>
            <div>
              <div>
                <span className="icon iconfont">&#xe865;</span>
                <span>直播课单个课程，用户学习进度达到<Input width="40"/>% 即视为“已完成”学习</span>
              </div>
              <div>
                <span className="icon iconfont">&#xe864;</span>
                <span>视频课单个课程，用户学习进度达到<Input  width="40"/>%即视为“已完成”学习</span>
              </div>
            </div>  
        </div>
    </div>
  );
}
export default withRouter(BasicInfo)
