/*
 * @Author: zhangleyuan
 * @Date: 2021-02-20 16:46:46
 * @LastEditors: zhangleyuan
 * @LastEditTime: 2021-02-21 15:46:25
 * @Description: 描述一下
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */

import React from 'react';
import { Table, Modal, message , Tooltip,Switch,Dropdown} from 'antd';
import { withRouter } from 'react-router-dom';
import { PageControl } from "@/components";
import './PlanList.less';

function PlanList(props) {
    
   
    function parseColumns(){
        const columns = [
            {
                title: '培训计划',
                key: 'planName',
                dataIndex: 'planName',
                width:'15%',
                render: (val, record) => {
                    return (
                        <div className="plan__name">
                        培训计划名称培训计划名称
                        </div>
                    )
                }
            },
            {
                title: '课程总数量',
                key: 'courseNumber',
                dataIndex: 'courseNumber',
                width: '10%',
                render: (val, record) => {
                return (
                    <div className="course-number">
                        20
                    </div>
                )
                }
            },
            {
                title: '当前状态',
                width: '10%',
                dataIndex: "status",
                render: (val, item, index) => {
                return  (
                    <Switch  defaultChecked={true} />
                ) 
                },
            },
            {
                title: '创建人',
                key: 'createName',
                dataIndex: 'createName',
                width: '10%',
                render: (val) => {
                return (
                    <div className="create-name">
                    张某某
                    </div>
                )
                }
            },
            {
                title: '创建时间',
                width: "10%",
                key: 'created',
                dataIndex: 'created',
                sorter: true,
                render: (val) => {
                return  formatDate('YYYY-MM-DD H:i', val) 
                }
            },
            {
                title: '更新时间',
                width: "10%",
                key: 'updated',
                dataIndex: 'updated',
                sorter: true,
                render: (val) => {
                return formatDate('YYYY-MM-DD H:i', val) 
                }
            },
            {
                title: '参培人数',
                width: "10%",
                key: 'joinNumber',
                dataIndex: 'joinNumber',
                sorter: true,
                render: (val) => {
                    return ( 
                        <div className="join-number">
                            3
                        </div>
                    ) 
                }
            },
            {
                title: '操作',
                key: 'operate',
                dataIndex: 'operate',
                width: '25%',
                fixed: 'right',
                render: (val, record) => {
                    return (
                        <div className="operate">
                            <div className="operate__item">学习数据</div>
                            <span className="operate__item split"> | </span>
                            <div className="operate__item">分享</div>
                            <span className="operate__item split"> | </span>
                            <Dropdown overlay={renderMoreOperate(record)}>
                                <span className="more-operate">
                                <span className="operate-text">更多</span>
                                <span
                                    className="iconfont icon"
                                    style={{ color: "#5289FA" }}
                                >
                                    &#xe824;
                                </span>
                                </span>
                            </Dropdown>
                        </div>
                    )
                }
            }
        ];
        return columns;
    }
    function renderMoreOperate(item){
        return (
            <div className="live-course-more-menu">
                <div  className="operate__item"
                >编辑</div>
                <div
                className="operate__item"
                >删除</div>
            </div>
        )
    }
    return (
        <div className="plan-list">
            <Table
                rowKey={record => record.id}
                dataSource={props.planListData}
                columns={ parseColumns() }
                pagination={false}
                bordered
            />
            <div className="box-footer">
                <PageControl
                    current={props.query.current - 1}
                    pageSize={props.query.size}
                    total={props.totalCount}
                    toPage={(page) => {
                        const _query = {...props.query, current: page + 1};
                        props.onChange(_query)
                    }}
                />
            </div>  
        </div>
    )
  }
  
  export default withRouter(PlanList);