import React from 'react';


import { PageControl, XMTable } from '@/components';


// import User from '@/common/js/user';
import './WechatUserAuditList.less'



function WechatUserAuditList(props) {
    const {listData , totalCount, query,onChange=()=>{}} =props
  function parseColumns() {
    const columns = [
      {
        title: '微信名称',
        key: 'planName',
        dataIndex: 'planName',
        width: '14%',
        fixed: 'left',
        render: (val, record) => {
          return (
            <div className='wechat-user-audit-name'>{val}</div>
          )
        },
      },
      {
        title: '真实姓名',
        key: 'createName',
        dataIndex: 'createName',
        width: '10%',
        render: (val) => {
          return <div className='create-name'>{val}</div>;
        },
      },
      {
        title: '申请时间',
        width: '12.5%',
        key: 'created',
        dataIndex: 'created',
        render: (val) => {
          return <span style={{ whiteSpace: 'nowrap' }}>{window.formatDate('YYYY-MM-DD H:i', val)}</span>;
        },
      },
      {
        title: '审批状态',
        width: '10%',
        key: 'updated',
        dataIndex: 'updated',
        render: (val) => {
          return <span style={{ whiteSpace: 'nowrap' }}>{window.formatDate('YYYY-MM-DD H:i', val)}</span>;
        },
      },
      {
        title: '审核人',
        width: '10%',
        key: 'cultureCustomerNum',
        dataIndex: 'cultureCustomerNum',
        render: (val) => {
          return <div className='join-number'>{val}</div>;
        },
      },
      {
        title: '操作',
        key: 'operate',
        dataIndex: 'operate',
        fixed: 'right',
        width: '14.5%',
        render: (val, record) => {
          return (
            <div className='operate'>
              <div className='operate__item' onClick={() => toLearningDataPage(record)}>
                通过
              </div>
              <span className='operate__item split'> | </span>
              <div className='operate__item' onClick={() => toLearningDataPage(record)}>
                拒绝
              </div>
            </div>
          );
        },
      },
    ];
    return columns;
  }
  
  function toLearningDataPage(record){
    console.log(record)
  }
  
  
  function onShowSizeChange(current, size) {
    if (current === size) {
      return;
    }
    let _query = query;
    _query.size = size;
    onChange(_query);
  }

  return (
    <div className='wechat-user-audit-list'>
      <XMTable
        rowKey={(record) => record.id}
        showSorterTooltip={false}
        dataSource={listData}
        columns={parseColumns()}
        pagination={false}

        bordered
        size='middle'
        scroll={{ x: 1400 }}
        className='wechat-user-audit-list-table'
        renderEmpty={{
          description: <span style={{ display: 'block', paddingBottom: 24 }}>暂无数据</span>,
        }}
      />
      <div className='box-footer'>
        <PageControl
          current={query.current - 1}
          pageSize={query.size}
          total={totalCount}
          toPage={(page) => {
            const _query = { ...query, current: page + 1 };
            onChange(_query);
          }}
          onShowSizeChange={onShowSizeChange}
        />
      </div>
    </div>
  );
}

export default WechatUserAuditList
