import React from 'react';
import { Row, Radio } from 'antd';
const WechatUserAuditOpt = function (props) {
  const { onChange = () => {}, defaultType = 'a' } = props;

  return (
    <div className='wechat-user-audit-filter'>
      <Row type='flex' justify='end' align='top'>
        <Radio.Group onChange={(e)=>onChange({type:e.target.value})} defaultValue={defaultType}>
          <Radio.Button value='a'>全部</Radio.Button>
          <Radio.Button value='b'>待审核</Radio.Button>
          <Radio.Button value='c'>已通过</Radio.Button>
          <Radio.Button value='d'>已拒绝</Radio.Button>
        </Radio.Group>
      </Row>
    </div>
  );
};
export default WechatUserAuditOpt;
