/*
 * @Author: leehu 
 * @Date: 2017-09-04 11:52:25 
 * @Last Modified by: zhujian
 * @Last Modified time: 2020-03-09 20:19:04
 */
import React from 'react';
import { Spin, Select } from 'antd';
import _ from 'underscore';
import classNames from 'classnames';

import Service from '@/common/js/service';

class CourseSelect extends React.Component {

  constructor(props) {
    super(props);
    this.state = {
      close: true,
      dataSource: [],
      query: {
        current: 1,
        size: 10000,
        showNumber: 100,
        courseNameLike: null,
      },
      dataSet: [],
      visible: false,
      loading: false,
      selectedIds: [],
      selected: props.selected || [],
    }
  }

  componentWillMount() {
    this.handleFetchCourseList();
  }

  handleQueryReset = () => {
    this.setState({
      query: {
        current: 1,
        size: 10000,
        showNumber: 100,
        courseNameLike: null,
      }
    }, () => {
      this.handleFetchCourseList();
    });
  }

  handleFetchCourseList(current = 1) {
    this.setState({ loading: true });
    let query = _.clone(this.state.query)
    if (this.props.queryAll) {
      delete query.status;
    }
    query.current = current;

    Service.Business('public/course/digestList', query)
      .then((res) => {
        const { result = {} } = res || {};
        let { records = [], total = 0, hasNext } = result;
        records.map(function (item, index) {
          item.title = item.name;
          item.desc = item.name;
          return item;
        });
        this.setState({
          dataSet: current > 1 ? [...this.state.dataSet, ...records] : records,
          isAll: !hasNext,
          loading: false,
          totalCount: Number(total),
        });
      }).finally((res) => {
        this.setState({ loading: false });
      });
  }

  handleCourseSelect = (course) => {
    const { query } = this.state;
    if (query.courseNameLike) {
      query.courseNameLike = null;
      this.setState({ query }, this.handleFetchCourseList);
    }
    this.props.onSelect(course);
  }

  render() {
    const {
      id,
      style,
      label,
      defaultValue,
      placeholder = '请选择'
    } = this.props;

    const { visible, query, dataSet, isAll } = this.state;

    return (
      <div
        className={classNames("common-select staticSelect", {
          'common-select-active': visible
        })}
        style={style}>
        {
          !!label && <div className='label'> {label}:</div>
        }
        <Select
          id={id}
          ref='course'
          showSearch
          allowClear
          onSearch={(value) => {
            query.courseNameLike = value
            this.setState({ query }, this.handleFetchCourseList)
          }}
          onBlur={() => {
            query.courseNameLike = null;
            this.setState({ query }, this.handleFetchCourseList)
          }}
          placeholder={placeholder}
          value={defaultValue}
          onChange={this.handleCourseSelect}
          filterOption={(input, option) => option}
        >
          {
            _.map(dataSet, (item, index) => {
              return <Select.Option id={'course_select_item_' + index} key={item.id} value={item.id} title={item.name}>
                {item.name}
              </Select.Option>
            })
          }
          {!isAll &&
            <Select.Option disabled style={{ textAlign: 'center' }} value="spin">
              <Spin size="small" />
            </Select.Option>
          }
        </Select>
      </div>
    )
  }
}

export default CourseSelect;