/*
 * @Author: 吴文洁
 * @Date: 2019-09-10 18:26:03
 * @LastEditors: zhangleyuan
 * @LastEditTime: 2020-12-22 15:39:35
 * @Description:
 */
import React , { useContext, useState}from 'react';
import './Header.less';
import {
  Menu,
  Dropdown,
  Modal
} from 'antd';
import { QuestionCircleOutlined } from "@ant-design/icons";
import { withRouter } from 'react-router-dom';

import User from '@/common/js/user';
import BaseService from "@/domains/basic-domain/baseService";
import { XMContext } from '@/store/context';
import logoImg from '@/common/images/logo.png';
const baseImg ='https://image.xiaomaiketang.com/xm/rJeQaZxtc7.png'
const { confirm } = Modal;
interface headerProps {
  menuType:boolean,
  handleMenuType:() => void
}

function Header(props:headerProps){
  const { menuType ,handleMenuType} = props;
  const ctx: any = useContext(XMContext);
  function userMenu() {
    return (
      <Menu
        style={{
          maxWidth: "250px",
          marginTop: 5,
        }}
       
      >
        <Menu.Item
          style={{whiteSpace: "normal", wordBreak: "break-all"}}
          key="1"
          onClick={() => toPersonalInfoPage()}
        >
          个人设置
        </Menu.Item>
        <Menu.Item
          style={{whiteSpace: "normal", wordBreak: "break-all"}}
          key="2"
          onClick={e => {
            handleLogoutConfirm();
          }}
        >
          退出登录
        </Menu.Item>
      </Menu>
    );
  }
  function handleMenu(){
    handleMenuType();
  };
  function toPersonalInfoPage(){
    window.RCHistory.push({
      pathname: `/personal-info`,
    })
  }
  function handleLogoutConfirm(){
    return confirm({
      title: "你确定要退出登录吗？",
      content: "退出后，需重新登录",
      icon: <span className="icon iconfont default-confirm-icon">&#xe839; </span>,
      okText: "退出登录",
      cancelText: "点错了",
      onOk: () => {
        handleLogout();
      },
    });
  }
  function handleLogout(){

    BaseService.logout({}).then((res) => {
      User.removeUserId();
      User.removeToken();
      window.RCHistory.push({
        pathname: `/login`,
      })
    });

  }
  return (
    <div id="top-container" className="top-container">
      <div className="top top-nav">
        <div>
          <img src={logoImg}  className="logo" alt="" />
          {menuType && (
          <span className="logo-name">小麦云课堂</span>
          )}
        </div>
        {menuType ? (
          <span className="icon iconfont cursor ml20  handLike" onClick={handleMenu}>
           &#xe83d;
          </span>
        ) : (
          <span className="icon iconfont cursor ml20  handLike" onClick={handleMenu}>
            &#xe615;
          </span>
        )}
        <div className="message-help">
        <div className="store-name">{User.getStoreName()}</div>
        <Dropdown overlay={userMenu()}>
            <div className="user">
              <img
                style={{
                  width: 32 + "px",
                  height: 32 + "px",
                  borderRadius: "50%",
                  overflow: "hidden",
                  flexShrink: 0,
                }}
               
                src={(ctx.xmState && ctx.xmState.storeList &&ctx.xmState.storeList[0].avatar) ? ctx.xmState.storeList[0].avatar:baseImg}
              />
                { ctx.xmState && ctx.xmState.storeList && (
                  <span className="name">{ctx.xmState.storeList[0].nickName}</span>
                  )
                }
            </div>
          </Dropdown>
        </div>
      </div>
    </div>
  );
}
export default Header;
