/*
 * @Author: yuananting
 * @Date: 2021-02-21 17:51:01
 * @LastEditors: yuananting
 * @LastEditTime: 2021-03-27 13:42:42
 * @Description: 助学工具-题库-题库主页面
 * @Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */

import React, { Component } from "react";
import "./QuestionBankIndex.less";
import QuestionBankSider from "../components/CourseCategorySiderTree";
import QuestionManageContent from "./components/QuestionManageContent";

class QuestionBankIndex extends Component {
  constructor(props) {
    super(props);
    this.state = {
      selectedCategoryId: "",
    };
  }

  componentDidMount() {}

  getCategoryIdFromSider = (selectedCategoryId) => {
    if (selectedCategoryId && selectedCategoryId.length > 0) {
      this.setState({ selectedCategoryId: selectedCategoryId[0] });
    }
  };

  updatedSiderTreeFromList = (currentTotal, updatedCategoryId) => {
    this.setState({ currentTotal, updatedCategoryId });
  };

  render() {
    return (
      <div className="question-bank-index page">
        <div className="content-header">题目</div>
        <div className="box content-body">
          <div
            style={{ borderRight: "0.5px solid #EEEEEE", paddingRight: "4px" }}
          >
            <div className="sider">
              <QuestionBankSider
                getSelectedCategoryId={this.getCategoryIdFromSider.bind(this)}
                currentTotal={this.state.currentTotal}
                updatedCategoryId={this.state.updatedCategoryId}
              />
            </div>
          </div>
          <div className="content">
            <QuestionManageContent
              updatedSiderTree={this.updatedSiderTreeFromList.bind(this)}
              selectedCategoryId={this.state.selectedCategoryId}
            />
          </div>
        </div>
      </div>
    );
  }
}

export default QuestionBankIndex;
