/*
 * @Author: 吴文洁
 * @Date: 2019-09-10 18:26:03
 * @LastEditors: zhangleyuan
 * @LastEditTime: 2020-12-04 15:30:49
 * @Description:
 */
import React from 'react';
import './Header.less';
import {
  Menu,
  Dropdown,
  Icon,
  message,
  Modal,
  Input,
  Avatar,
  Button,
  Row,
  Col,
  Badge,
  Tooltip,
  Radio,
} from 'antd';
import { withRouter } from 'react-router-dom';
import Bus from '@/core/bus';
import User from '@/common/js/user';
import axios  from 'axios';
import BaseService from "@/domains/basic-domain/baseService";
// var $topContainer = $('#top-container');
class Header extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      menuType: 1,
    };
  }
  componentDidMount() {
    
  }
  userMenu() {
    const style = {
      whiteSpace: "normal",
      wordBreak: "break-all"
    };
    return (
      <Menu
        style={{
          maxWidth: "250px",
          marginTop: 5,
        }}
        onClick={e => {
          if (e.key === '1') {
            window.RCHistory.push('/user_info');
            Bus.trigger('clearSearchText')
          } else {
            this.handleLogout();
          }
        }}
      >
        <Menu.Item
          style={style}
          key="2"
        >
          退出登录
        </Menu.Item>
      </Menu>
    );
  }
  handleMenu = () => {
    const menuType = !this.state.menuType;
    this.setState({ menuType }, () => {
      Bus.trigger('menuTypeChange', menuType);
    });
  };
  handleLogout() {
    // const AxiosInstance = axios.create({
    //   headers: {
    //     xmToken: User.getToken(),
    //   }
    // });
    
    // AxiosInstance.post('https://dev-heimdall.xiaomai5.com/hades/public/store/logout').then((res) => {
    //   User.removeUserId();
    //   User.removeToken();
    //   window.RCHistory.push({
    //     pathname: `/login`,
    //   })
    // })
    BaseService.logout().then((res) => {
      User.removeUserId();
      User.removeToken();
      window.RCHistory.push({
        pathname: `/login`,
      })
    });
  }

  render() {
    const {
    } = this.state;
    return (
      <div id="top-container" className="top-container">
        <div className="top top-nav">
          <div>
            {this.state.menuType ? (
              <img src="https://image.xiaomaiketang.com/xm/TP2x7aQ24y.png" className="logo" alt="" />
            ):(
              <img src="https://dev.xiaomai5.com/admin/static/images/logo.928339cd.png" className="logo" alt="" />
            )}
          </div>
          {this.state.menuType ? (
            <span className="icon iconfont cursor ml20  handLike" onClick={this.handleMenu}>
              &#xe83d;{' '}
            </span>
            
          ) : (
            <span className="icon iconfont cursor ml20  handLike" onClick={this.handleMenu}>
              &#xe615;
            </span>
          )}
          <div className="message-help">
          <Dropdown overlay={this.userMenu()}>
              <div className="user">
                <Avatar
                  style={{
                    width: 32 + "px",
                    height: 32 + "px",
                    borderRadius: "50%",
                    overflow: "hidden",
                    flexShrink: 0,
                  }}
                  size="large"
                  src="@/common/images/xiaomai-IMG.png"
                />
                <span className="name">张乐园</span>
              </div>
            </Dropdown>
          </div>
        </div>
      </div>
    );
  }
}

export default withRouter(Header);
