/*
 * @Author: yuananting
 * @Date: 2021-08-05 10:55:49
 * @LastEditors: wufan
 * @LastEditTime: 2021-08-09 15:49:31
 * @Description: 个人学习详情
 * @Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React from 'react';
import { Progress, Space, Tabs } from 'antd';
import Breadcrumbs from '@/components/Breadcrumbs';
import WholeData from './components/WholeData';
import ENUM from '../enum';
import TestLinkTaskData from './components/TestLinkTaskData';

import './UserLearningData.less';

const { TabPane } = Tabs;

function UserLearningData(props) {
  const tabList = [
    {
      name: '全部',
      key: 'whole',
      compoment: WholeData,
    },
    {
      name: '考试',
      key: 'exam',
      compoment: TestLinkTaskData, // todo
    },
  ];

  return (
    <div className='page user-learning-data'>
      <Breadcrumbs
        navList='学员学习数据'
        goBack={() => {
          props.history.goBack();
        }}
      />
      <div className='header'>
        <div className='train-title'>培训任务全新版本上线啦～🐹🐹</div>
        <div className='data-info'>
          <div className='user-name'>学员：{'文小小'}</div>
          <div className='complete-progress'>
            任务完成率：
            <div style={{ width: 120 }}>
              <Progress size={120} strokeColor='#2966FF' trailColor='#EAEAEA' percent={30} size='small' />
            </div>
          </div>
          <Space size={24}>
            <div>
              <img src={ENUM.LearningContentIcon['COURSE']} />
              课程：{'15/98'}
            </div>
            <div>
              <img src={ENUM.LearningContentIcon['EXAM']} />
              考试：{'15/98'}
            </div>
          </Space>
        </div>
      </div>
      <div className='gap-line'></div>
      <div className='content'>
        <Tabs defaultActiveKey={'whole'} onChange={() => {}}>
          {tabList.map((item) => {
            return (
              <TabPane tab={item.name} key={item.key}>
                {<item.compoment />}
              </TabPane>
            );
          })}
        </Tabs>
      </div>
    </div>
  );
}

export default UserLearningData;
