/*
 * @Author: 吴文洁
 * @Date: 2019-07-10 10:30:49
 * @LastEditors: wufan
 * @LastEditTime: 2021-03-26 16:13:48
 * @Description:
 */
import React, { useContext, useEffect, useState } from 'react';
import { withRouter } from 'react-router-dom';
import { ConfigProvider, message } from 'antd';
import Header from './Header'
import Menu from './Menu'
import Main from './Main'
import zhCN from 'antd/es/locale/zh_CN'
import User from '@/common/js/user';
import BaseService from "@/domains/basic-domain/baseService";
import { XMContext } from '@/store/context';
import { setStoreGroupPermission, setStorePermission, setStoreGroupList, setStoreList } from '@/store/actions/index';
import Service from "@/common/js/service";
import Bus from '@/core/tbus';
import { func } from 'prop-types';

declare var window: any;

const App: React.FC = (props: any) => {
  const [storeUserId, setStoreUserId] = useState('')
  const ctx: any = useContext(XMContext);
  const userId = User.getUserId();
  const [menuType, setMenuType] = useState(true);
  const enterpriseId = User.getEnterpriseId();
  window.ctx = ctx;


  useEffect(() => {
    getStoreAndUserInfo();
    if (window.location.hash === "#/") {
      window.RCHistory.replace({
        pathname: '/home',
      })
    }
  }, [])

  function getStorePermission() {
    const params = {
      storeId: User.getStoreId(),
    };
    Service.Hades('public/customerHades/whetherStopStore', params).then((res) => {
      if (res.result) {
        window.RCHistory.replace({
          pathname: '/error-college',
        })
      }
    });
  }

  async function getStoreAndUserInfo() {
    await (enterpriseId ? getStoreInfo() : getStoreGroupAndStoreList());
  }

  function getStoreInfo() {
    const params = {
      storeId: User.getStoreId(),
      userId: User.getUserId(),
    };
    Service.Hades('public/customerHades/getStoreAndUserMsg', params).then((res) => {
      const { id, storeUserId, storeName, userRole, storeType } = res.result;
      User.setStoreId(id);
      User.setStoreUserId(storeUserId);
      User.setStoreName(storeName);
      Bus.trigger('storeNameChange',storeName);
      User.setUserRole(userRole);
      User.setStoreType(storeType);
      setStoreUserId(storeUserId)
      getUserPermission();
      getStorePermission();
    })
  }

  function getStoreGroupAndStoreList() {

    BaseService.getUserStore({ userId }).then((res) => {

      const { storeGroupVOS = [], storeVOS = [] } = res.result;
      if (storeVOS.length < 1) {
        message.warning('店铺不存在');
        window.RCHistory.replace('/login');
        return
      }
      const { id, storeUserId, storeName, userRole, storeType } = storeVOS[0];

      User.setStoreId(id);
      User.setStoreUserId(storeUserId);
      User.setStoreName(storeName);
      Bus.trigger('storeNameChange', storeName);
      User.setUserRole(userRole);
      User.setStoreType(storeType);
      ctx.dispatch(setStoreGroupList(storeGroupVOS))
      ctx.dispatch(setStoreList(storeVOS));
      setStoreUserId(storeUserId)
      getUserPermission();
      getStorePermission();
    });
  }

  function getUserPermission() {
    BaseService.getUserPermission({}).then((res) => {
      console.log(res.result);
      const { storePermission, storePermissionGroup, storeUserPermission, storeUserPermissionGroup } = res.result;
      ctx.dispatch(setStoreGroupPermission(storePermissionGroup))
      ctx.dispatch(setStorePermission(storeUserPermissionGroup))
    });
  }
  function handleMenuType() {
    setMenuType(!menuType);
  }


  if (!storeUserId) {
    return <div></div>
  }

  return (
    <div id="home">
      <Header id="app" handleMenuType={handleMenuType} menuType={menuType} />
      <ConfigProvider locale={zhCN} autoInsertSpaceInButton={false}>
        <Main menuType={menuType} />
      </ConfigProvider>
      <Menu menuType={menuType} />
    </div>
  )
}

export default withRouter(App)
