import User from '@/common/js/user';
import StoreService from '@/domains/store-domain/storeService';
import { Menu } from 'antd';
import React, { Key, useContext, useEffect, useMemo, useState } from 'react';
import { withRouter } from 'react-router-dom';
import _ from 'underscore';
import { menuList } from '../../routes//config/menuList';
import { XMContext } from '../../store/context';
import './Menu.less';

const { SubMenu } = Menu;
function Aside(props: any) {
  const { menuType, handleMenuType } = props;
  const ctx: any = useContext(XMContext);
  const [selectKey, setSelectKey] = useState();
  const [selectKeyParent, setSelectKeyParent] = useState();
  const [openKeys, setOpenKeys] = useState(['']);
  const [topLogoUrl, setTopLogoUrl] = useState('');
  const [collapsed, setCollapsed] = useState(false);
  const rootSubmenuKeys = _.pluck(menuList, 'groupCode');

  useEffect(() => {
    const link = props.location.pathname;
    menuList.map((item: any, index: any) => {
      if (link.indexOf(item.link) !== -1) {
        setSelectKey(item.groupCode);
        setSelectKeyParent(item.groupCode);
        setOpenKeys([]);
      } else if (item.children) {
        item.children.map((_item: any, _index: any) => {
          if (link.indexOf(_item.link) !== -1) {
            setSelectKeyParent(item.groupCode);
            setSelectKey(_item.groupCode + index + _index);
          }
        });
      }
      return item;
    });
  }, [props.location.pathname]);
  useEffect(() => {
    getTopLeftLogo();
  }, []);

  function getTopLeftLogo() {
    if (User.getToken()) {
      StoreService.getStoreDetail({ storeId: User.getStoreId() }).then((res) => {
        if (_.isEmpty(res.result.logo)) {
          setTopLogoUrl('https://image.xiaomaiketang.com/xm/fe4NCjr7XF.png');
        } else {
          setTopLogoUrl(res.result.logo);
        }
      });
    }
  }

  function toggleMenu(item: any, selectKey: any) {
    console.log('item', item, selectKey);
    setSelectKeyParent(selectKey);
    window.RCHistory.push(item.link);
    if (!menuType) {
      setOpenKeys([]);
    }
  }

  function onOpenChange(key: Key[]) {
    if (typeof key === 'string') {
      if (openKeys.includes(key)) {
        setOpenKeys([]);
      } else {
        setOpenKeys([key]);
      }
    }
  }

  function onOpenChangeForHover(key: Key[]) {
    if (menuType) {
      return;
    }
    if (typeof key === 'string') {
      if (openKeys.includes(key)) {
        setOpenKeys([]);
      } else {
        setOpenKeys([key]);
      }
    }
  }

  function handleMenu() {
    handleMenuType();
    setCollapsed(!collapsed);
  }

  const openKeysConstrol = useMemo(() => {
    return {
      [menuType ? 'openKeys' : 'defaultOpenKeys']: openKeys,
    };
  }, [menuType, openKeys]);

  return (
    <div id='left-container' className={menuType ? 'left-container' : 'left-container left-container-vertical'}>
      <div className='top-ctrl'>
        <div className='topLogo'>{menuType && <img src={topLogoUrl} alt='' className='img1'></img>}</div>
        <div className='menu-type-icon' onClick={handleMenu}>
          {menuType ? <span className='icon iconfont'>&#xe83d;</span> : <span className='icon iconfont'>&#xe615;</span>}
        </div>
      </div>

      <div className='left'>
        <div className='nav'>
          <Menu
            {...openKeysConstrol}
            style={menuType ? { minHeight: '100%', background: '#0E1935' } : { minHeight: '100%', background: '#0E1935', width: '56px' }}
            selectedKeys={selectKey}
            onOpenChange={onOpenChange}
            inlineCollapsed={collapsed}
            mode={menuType ? 'inline' : 'vertical'}>
            {menuList.map((item: any, index: any) => {
              if (ctx.xmState.storeUserPermissionList.indexOf(item.groupCode) === -1) {
                return null;
              }
              if (item.children) {
                return (
                  <SubMenu
                    key={item.groupCode}
                    style={{ marginTop: 0 }}
                    icon={
                      !menuType && item.groupCode === selectKeyParent ? (
                        <div className='icon-img-box' style={{ backgroundColor: '#2966FF', width: '40px', height: '40px' }}>
                          <img src={item.selectImg} className='icon-img' />
                        </div>
                      ) : (
                        <div className='icon-img-box' style={{ backgroundColor: '#fff', width: '40px', height: '40px', display: 'inline-block' }}>
                          <img src={item.img} className='icon-img' />
                        </div>
                      )
                    }
                    title={menuType ? <span>{item.groupName}</span> : ''}
                    onTitleClick={() => onOpenChange(item.groupCode)}>
                    {item.children.map((_item: any, _index: any) => {
                      if (ctx.xmState.storeUserPermissionList.indexOf(_item.groupCode) === -1) {
                        return null;
                      }
                      return (
                        <Menu.Item
                          onClick={() => {
                            toggleMenu(_item, item.groupCode);
                          }}
                          style={{ marginTop: 0 }}
                          key={_item.groupCode + index + _index}>
                          <span className='name'>{_item.groupName}</span>
                        </Menu.Item>
                      );
                    })}
                  </SubMenu>
                );
              } else {
                return (
                  <Menu.Item
                    onClick={() => {
                      toggleMenu(item, item.groupCode);
                    }}
                    key={item.groupCode}
                    icon={
                      !menuType && item.groupCode === selectKeyParent ? (
                        <div className='icon-img-box' style={{ backgroundColor: '#2966FF', width: '40px' }}>
                          <img src={item.selectImg} className='icon-img' />
                        </div>
                      ) : (
                        <div className='icon-img-box' style={{ width: '30px' }}>
                          <img src={selectKey === item.groupCode ? item.selectImg : item.img} className='icon-img' />
                        </div>
                      )
                    }>
                    {menuType ? item.groupName : ''}
                  </Menu.Item>
                );
              }
            })}
          </Menu>
        </div>
      </div>
    </div>
  );
}

export default withRouter(Aside);
