/*
 * @Author: 吴文洁 
 * @Date: 2020-07-14 15:42:24 
 * @Last Modified by: 吴文洁
 * @Last Modified time: 2020-07-23 14:35:28
 * @Description: 大班直播、互动班课的操作区
 */

import React from 'react';
import { Button, Modal, message } from 'antd';
import Service from '@/common/js/service';
import './liveCourseOpt.less';
import BaseService from "@/domains/basic-domain/baseService";
class LiveCourseOpt extends React.Component {
  constructor(props) {
    super(props);
  }
  handleCreateLiveCouese = ()=>{
    window.RCHistory.push({
      pathname: '/create-live-course?type=add',
    })
  }
  // 下载直播客户端
  handleDownloadClient = () => {
    const isMac = /macintosh|mac os x/i.test(navigator.userAgent);
    // 判断用户系统
    let platform;
    if(!isMac){
      platform = 1
    }else{
      platform = 4
    }
    BaseService
    .getLastedVersion({ model: 5, platform})
    .then((res) => {
      const a = document.createElement("a");
      document.body.appendChild(a);
      a.href = res.result.releaseUrl;
      a.click();
      document.body.removeChild(a);
    })
  }
  render() {
    return (
      <div className="live-course-opt">
        <div className="opt__left">
          <Button type="primary" onClick={this.handleCreateLiveCouese}>新建直播课</Button>
          <Button onClick={this.handleDownloadClient}>下载直播客户端</Button>
        </div>
      </div>
    )
  }
}

export default LiveCourseOpt;