import React, { useEffect, useState } from "react";
import { DatePicker, TimePicker, Select } from 'antd';
import StoreService from "@/domains/store-domain/storeService";
import "./AddLiveClassInfoWorkWX.less";
import GraphicsEditor from "./GraphicsEditor";
import moment from "moment";
import _ from "underscore";
const { Option } = Select;

const defaultTeacherQuery = {
    size: 15,
    current: 1,
    nickName:null
  }

export default function AddLiveClassInfoWorkWX(props) {

    const [teacherQuery, setTeacherQuery] = useState(defaultTeacherQuery)
    const [teacherList, setTeacherList] = useState([])
    const [introduce, setIntroduce] = useState({content:props.introduce})
    const [duration, setDuration] = useState(props.data.duration)
    const [cusTime, setCusTime] = useState(false)

    const [beginDate, setBeginDate] = useState(0)
    const [beginTime, setBeginTime] = useState(0)
    const [endDate, setEndDate] = useState(0)
    const [endTime, setEndTime] = useState(0)
    const [teacherId, setTeacherId] = useState()
    const [remindTime, setRemindTime] = useState(0)

    useEffect(()=> {
        getTeacherList()
    },[])

    useEffect(()=> {
        setBeginTime(props.data.startTime)
        setBeginDate(moment(props.data.startTime).startOf('day').valueOf())
        setEndTime(props.data.startTime+Number(props.data.duration))
        setEndDate(moment(props.data.startTime+Number(props.data.duration)).startOf('day').valueOf())

        setTeacherId(props.data.teacherId)
        setRemindTime(props.data.remindTime)
    },[props.data])

    useEffect(()=> {
        let intro = {content:props.introduce};
        setIntroduce(intro)
    },[props.introduce])

    //开始日期
    function onBeginDateChange(date, dateString) {
        if (date) {
            setBeginDate(date.startOf('day').valueOf())
        } else {
            setBeginDate(0)
        }
    }

    function onBeginDateOK(date) {
        console.log(date)
    }
    //开始时间
    function onBeginTimeChange(date, dateString) {
        console.log("onBeginTimeChange",date)
        // props.onChange("beginTime",date.valueOf())
    }

    function onBeginTimeOK(time) {
        let begin = beginDate+(time.hour()*60+time.minute())*60*1000
        setBeginTime(begin)
        props.onChange("beginTime",begin)
        if (!cusTime) {
            props.onChange("endTime",begin+duration)
        }
        
    }
    //结束日期
    function onEndDateChange(date, dateString) {
        if (date) {
            setEndDate(date.startOf('day').valueOf())
        } else {
            setEndDate(0)
        }
        
    }

    function onEndDateOK(date) {

    }
    //结束时间
    function onEndTimeChange(date, dateString) {
        // props.onChange("endTime",date.valueOf())
    }

    function onEndTimeOK(time) {
        let end = endDate+(time.hour()*60+time.minute())*60*1000
        setEndTime(end)
        props.onChange("endTime",end)
    }

    function onDurationChange(value, option) {
        if (value === 0) {
            setCusTime(true)
            return
        }
        let d = value*60*1000;
        setDuration(d)
        props.onChange("endTime",beginDate+d)
    }

    function onTeacherChange(value, option) {
        setTeacherId(value)
        props.onChange("teacherId",value)
    }

    function onRemindChange(value, option) {
        setRemindTime(value)
        props.onChange("remindTime",value)
    }

    function onChangeIntro(val) {
        let intro = {...introduce}
        intro.content = val
        setIntroduce(intro)
        props.onChange("intro",val)
    }

    function getTeacherList(current = 1) {
        const _query = {
          ...teacherQuery,
          current,
          size:100
        };
        StoreService.getStoreUserBasicPage( _query).then((res) => {
            const { result = {} } = res;
            const { records = [], total = 0, hasNext } = result;
            const list = current > 1 ? teacherList.concat(records) : records;
            setTeacherList(list)
            setTeacherQuery({..._query,hasNext})
        });
    }

    // console.log(moment(beginDate).format("YYYY-MM-DD HH:mm"))
    // console.log(moment(endDate).format("YYYY-MM-DD HH:mm"))
    return (
        <div className="AddLiveClassInfoWorkWX">
            <div className="begin-time item">
                <span className="label"><span className="require">*</span>开始时间：</span>
                <DatePicker  
                value={beginTime===0?undefined:moment(beginTime)}
                onChange={onBeginDateChange} 
                onOk={onBeginDateOK} 
                />
                <TimePicker 
                value={beginTime===0?undefined:moment(beginTime)}
                onChange={onBeginTimeChange} 
                onOk={onBeginTimeOK} 
                format="HH:mm" />
            </div>
            <div className="duration-time item">
                {
                    cusTime || props.type === "edit" ? (
                        <>
                        <span className="label"><span className="require">*</span>结束时间：</span>
                        <DatePicker 
                        value={endTime === 0?undefined:moment(endTime)}
                        onChange={onEndDateChange} 
                        onOk={onEndDateOK} 
                        />
                        <TimePicker 
                        value={endTime === 0?undefined:moment(endTime)}
                        onChange={onEndTimeChange} 
                        onOk={onEndTimeOK} 
                        format="HH:mm" />
                        </>
                    ) : (
                        <>
                        <span className="label"><span className="require">*</span>时长：</span>
                        <Select onChange={onDurationChange} defaultValue={60} style={{width:"140px"}}>
                            <Option value={30}>0.5小时</Option>
                            <Option value={60}>1.0小时</Option>
                            <Option value={120}>2.0小时</Option>
                            <Option value={180}>3.0小时</Option>
                            <Option value={0}>自定义结束时间</Option>
                        </Select>
                        </>
                    )
                }

            </div>
            <div className="teacher item">
                <span className="label"><span className="require">*</span>讲师：</span>
                <Select 
                value={teacherId}
                onChange={onTeacherChange} 
                style={{width:"240px"}} 
                placeholder="请选择讲师"
                >
                    {
                    _.map(teacherList, (item, index) => {
                        return (
                        <Select.Option value={item.id} key={item.id}>{item.nickName}</Select.Option>
                        );
                    })
                    }
                </Select>
            </div>
            <div className="remind-time item">
                <span className="label"><span className="require">*</span>提醒时间：</span>
                <Select value={remindTime} onChange={onRemindChange} defaultValue={0} style={{width:"100px"}}>
                    <Option value={0}>无</Option>
                    <Option value={300}>5分钟前</Option>
                    <Option value={3600}>1小时前</Option>
                    <Option value={86400}>1天前</Option>
                </Select>
            </div>
            <div className="introduce item">
                <span className="label">直播简介：</span>
                <div className="intro-edit">
                    <GraphicsEditor
                    id='intro'
                    isIntro={true}
                    maxLimit={1000}
                    detail={introduce}
                    onChange={(val) => {
                      onChangeIntro(val);
                    }}
                    ></GraphicsEditor>
                </div>
            </div>
        </div>
    )
}