import PropTypes from 'prop-types';
import React from 'react';
import { DatePicker } from 'antd';
import moment from 'moment';
const { RangePicker } = DatePicker;

class DateRangePicker extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      visible: false
    }
  }

  render() {
    const showTime = { showTime: false }
    return (
      <RangePicker
        {...this.props}
        format={this.props.format || 'YYYY-MM-DD'}
        allowClear={this.props.allowClear}
        onChange={(date) => {
          if (!_.isEmpty(date)) {
            date[0] = date[0].startOf('day')
            date[1] = date[1].endOf('day')
          }
          this.props.onChange(date)
        }}
        {...showTime}
      />
    )
  }

}

DateRangePicker.propTypes = {

};

DateRangePicker.defaultProps = {
  allowClear: true,
}

export default DateRangePicker;