import React from 'react';
import "./PreviewFileModal.less";
import { Spin } from 'antd'
class PreviewFileModal extends React.Component {
  constructor(props) {
    super(props);
    this.state = {};
  }
  cancelPreView = ()=>{
    this.props.onCancel();
  }
  toPreView = (url)=>{
    const a = document.createElement('a');
    document.body.appendChild(a);
    a.setAttribute('href', url);
    a.setAttribute('target', '_blank');
    a.click();
    document.body.removeChild(a);
    this.props.onCancel();
  }
  render() {
    const { previewStatus,url} = this.props
    return (
        <div className="preview-modal">
            <div className="preview-modal-content">
                <div className="load-img-box">
                {previewStatus === "UPLOAD" && 
                  <Spin size="large"/>
                }
                {previewStatus === "UPLOAD_SUCCESS" && 
                  <img className="load-img" src="https://image.xiaomaiketang.com/xm/jJRK3bTEdc.png"></img>
                }
                </div>
                <div className="load-text-box">
                {previewStatus === "UPLOAD" && 
                  <div className="load-text-box-title">预览生成中</div>
                }
                {previewStatus === "UPLOAD_SUCCESS" && 
                  <div className="load-text-box-title">预览生成成功</div>
                }
                </div>
                <div className="operate">
                    <span className="btn cancel-preview-btn" onClick={()=>this.cancelPreView()}>取消预览</span>
                    {previewStatus === "UPLOAD" &&
                     <span className="btn to-preview-btn__disabled to-preview-btn">去查看</span>
                    }
                    {previewStatus === "UPLOAD_SUCCESS" &&
                     <span className="btn to-preview-btn" onClick={()=>this.toPreView(url)}>去查看</span>
                    }
                </div>
            </div>
        </div>
    );
  }
}

export default PreviewFileModal;
