/*
 * @Author: wufan
 * @Date: 2020-11-30 10:47:38
 * @LastEditors: wufan
 * @LastEditTime: 2021-06-21 11:17:44
 * @Description: 学院装修页面
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */

import React, { useState } from "react";
import { withRouter } from "react-router-dom";
import _ from "underscore";
import { Tabs } from "antd";
import "./StoreDecorationPage.less";
import StoreH5DecorationTab from "./StoreH5DecorationTab";
import StoreWebDecorationTab from "./StoreWebDecorationTab";

const { TabPane } = Tabs;
interface StoreDecoprationProps {
  match: {
    url: string;
  };
}

function StoreDecorationPage(props: StoreDecoprationProps) {
  const [currentTab, setCurrentTab] = useState("h5");

  return (
    <div className="page store-decoration-page">
        <div className="content-header">学院装修</div>
        <div className="box">
          <Tabs
            onChange={(key) => {
              setCurrentTab(key);
            }}
            activeKey={currentTab}
          >
            <TabPane key="h5" tab="H5学院"></TabPane>

            <TabPane key="web" tab="网页端学院"></TabPane>
          </Tabs>
          {
            currentTab === 'h5' && <StoreH5DecorationTab/>
          }
          {
            currentTab === 'web' && <StoreWebDecorationTab/>
          }
          
        </div>
    </div>
  );
}

export default withRouter(StoreDecorationPage);
