/*
 * @Author: chenjianyu
 * @Date: 2020-09-12 17:00:44
 * @LastEditTime: 2021-03-27 14:02:17
 * @LastEditors: yuananting
 * @Description: 答题模式模板
 * @Copyright © 2020 杭州杰竞科技有限公司 版权所有
 */

export function defineModuleData(index) {
  return {
    questionInfoVOList: [], // 题目内容
    taskModuleContentVOList: [], // 模块说明内容
    taskModuleInfoVO: {
      key: window.random_string(16),
      name: `题目模块${index}`,
    }
  }
}

export function defineQuestionData(questionType) {
  return {
    taskModuleQuestionVO: { // 题目信息
      key: window.random_string(16),
      questionType, // 题目类型
      itemTypeEnum: 'RIGHT_OR_WRONG',
      questionLevel: 0,
      questionTypeEnum: questionType,
      // score: 1, // 本题分值
    },
    itemInfoVOList: [], // 选项
    topicDescribeVOList: [{
      content: '',
      type: 'TEXT',
      contentType: 'TEXT'
    }], // 题干
    parsingDescribeVOList: [{
      content: '',
      type: 'TEXT',
      contentType: 'TEXT'
    }], // 答案解析
    lowerLevelQuestionInfoVOList: [],
    showBox: true,
  }
}

export function defineQuestionInfo(questionType) {
  return {
    questionTypeEnum: questionType, // 题目类型
    questionStemList:[
      {
        contentType: "QUESTION_STEM", // 内容类型（默认题干）
        content: "", // 内容
        type: "RICH_TEXT", // 内容项形式（0:富文本 1:文字 2:图片 3:语音 4:视频 5文件 6.课件）
      }
    ], // 题干
    optionList: questionType === "JUDGE" ? [] : [], // 非填空题选项
    gapFillingAnswerList: [
      // {
      //   correctAnswerList: []
      // }
    ], //填空题填空项
    questionAnswerDescList: [
      {
        contentType: "QUESTION_ANSWER_DESC", // 内容类型（默认解析）
        content: "", // 内容
        type: "RICH_TEXT", // 内容项形式（0:富文本 1:文字 2:图片 3:语音 4:视频 5文件 6.课件）
      }
    ], //答案解析
    showBox: true, // 显示录音弹窗
  }
}

export function defineOptionInfo() {
  return {
    isCorrectAnswer: 0, // 是否为正确答案选项
    questionOptionContentList: [ // 选项内容
      {
        contentType: "QUESTION_OPTION", // 内容类型（默认选项）
        content: "", // 内容
        type: "RICH_TEXT", // 内容项形式（0:富文本 1:文字 2:图片 3:语音 4:视频 5文件 6.课件）
      }
    ]
  }
}

export function defineJudgeOptionInfo(content) {
  return {
    isCorrectAnswer: 0, // 是否为正确答案选项
    questionOptionContentList: [ // 选项内容
      {
        contentType: "QUESTION_OPTION", // 内容类型（默认选项）
        content, // 内容
        type: "RICH_TEXT",
      }
    ]
  }
}

export function defineOptionData(content = '') {
  return {
    itemContentVOList: [{
      content,
      type: 'TEXT',
      contentType: 'TEXT'
    }], // 题目项内容
    questionItemVO: { // 题目项信息
      ifCorrectAnswerItem: false,
      key: window.random_string(16),
    }
  }
}