import React, { useEffect, useState } from "react";
import BaseService from "@/domains/basic-domain/baseService";
import { Tooltip } from "antd"
import ContactWidget from "@/components/ContactWidget";
import "./LimitTip.less"

export default function LimitTip(props:{total:number,type:string,tip:() => React.ReactNode}) {

    const [isOver, setIsOver] = useState(false)
    const [limitUser, setLimitUser] = useState(0)
  
    useEffect(()=> {
      BaseService.getLesseeVersionMsg()
      .then(res=> {
        setIsOver(res.result.surplusUserNum === 0 || res.result.whetherReachUserNum)
        setLimitUser(res.result.userNum)
      })
    },[])
  
    return (
      <div className="limit-tip">
        <div className="always">本学院{props.type}共<span style={{color:"#333333",fontWeight:"bold"}}>{props.total}</span>人
        <Tooltip overlayStyle={{maxWidth:"587px",width:"fit-content"}} placement="topLeft" arrowPointAtCenter title={props.tip}>
          <span className="icon iconfont" style={{cursor:"pointer",marginLeft:"4px",color:"#bfbfbf"}}>&#59449;</span>
        </Tooltip>
        {
          isOver ? (
            <>
            <div style={{marginLeft:"14px",display:"inline-block"}}>当前企业使用人数已达到上限 (<span style={{color:"#333333",fontWeight:"bold"}}>{limitUser}</span>人)，将无法添加新员工、新学员，如需增加人数限制，请联系小麦企学院服务平台。</div>
            <ContactWidget trigger="hover" placement="bottom">
              <div className="renew-text">立即续费<span className="icon iconfont" style={{fontSize:"10px"}}>&#59291;</span></div>
            </ContactWidget>
            </>
          ) : ("")
        }
        </div>
      </div>
    )
  }