import React, { useEffect, useState } from "react";
import { DatePicker, Select } from 'antd';
import StoreService from "@/domains/store-domain/storeService";
import "./AddLiveClassInfoWorkWX.less";
import GraphicsEditor from "./GraphicsEditor";
const { Option } = Select;

const defaultTeacherQuery = {
    size: 15,
    current: 1,
    nickName:null
  }

export default function AddLiveClassInfoWorkWX(props) {

    const [teacherQuery, setTeacherQuery] = useState(defaultTeacherQuery)
    const [teacherList, setTeacherList] = useState([])
    const [introduce, setIntroduce] = useState()

    useEffect(()=> {
        getTeacherList()
    },[])


    function onBeginTimeChange(date, dateString) {
        props.onChange("beginTime",date.valueOf())
    }

    function onBeginTimeOK() {

    }

    function onDurationChange(value, option) {

    }

    function onRemindChange(value, option) {

    }

    function onChangeIntro(val) {
        props.onChange("intro",val)
    }

    function getTeacherList(current = 1) {
        const _query = {
          ...teacherQuery,
          current,
          size:15
        };
        StoreService.getStoreUserBasicPage( _query).then((res) => {
            const { result = {} } = res;
            const { records = [], total = 0, hasNext } = result;
            const list = current > 1 ? teacherList.concat(records) : records;
            setTeacherList(list)
            setTeacherQuery({..._query,hasNext})
        });
    }

    return (
        <div className="AddLiveClassInfoWorkWX">
            <div className="begin-time item">
                <span className="label"><span className="require">*</span>开始时间：</span>
                <DatePicker showTime onChange={onBeginTimeChange} onOk={onBeginTimeOK} />
            </div>
            <div className="duration-time item">
                <span className="label"><span className="require">*</span>时长：</span>
                <Select onChange={onDurationChange} defaultValue="60">
                    <Option value="30">0.5小时</Option>
                    <Option value="60">1.0小时</Option>
                    <Option value="120">2.0小时</Option>
                    <Option value="180">3.0小时</Option>
                </Select>
            </div>
            <div className="teacher item">
                <span className="label"><span className="require">*</span>讲师：</span>
                <Select 
                onChange={onDurationChange} 
                style={{width:"240px"}} 
                placeholder="请选择讲师"
                >
                    {
                    _.map(teacherList, (item, index) => {
                        return (
                        <Select.Option value={item.userId} key={item.userId}>{item.nickName}</Select.Option>
                        );
                    })
                    }
                </Select>
            </div>
            <div className="remind-time item">
                <span className="label"><span className="require">*</span>提醒时间：</span>
                <Select onChange={onRemindChange} defaultValue="0" style={{width:"100px"}}>
                    <Option value="0">无</Option>
                    <Option value="5">5分钟前</Option>
                    <Option value="60">1小时前</Option>
                    <Option value="1440">1天前</Option>
                </Select>
            </div>
            <div className="introduce item">
                <span className="label">直播简介：</span>
                <div className="intro-edit">
                    <GraphicsEditor
                    id='intro'
                    isIntro={true}
                    maxLimit={1000}
                    detail={{
                      content: introduce,
                    }}
                    onChange={(val) => {
                      onChangeIntro(val);
                    }}
                    ></GraphicsEditor>
                </div>
            </div>
        </div>
    )
}