import React from 'react';
import {Table, Modal,Input} from 'antd';
import { PageControl } from "@/components";
import StoreService from "@/domains/store-domain/storeService";
import User from '@/common/js/user'
import './UserLearnDetailModal.less';
import _ from "underscore";
const { Search } = Input;
class UserLearnDetailModal extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      planDataSource:[
        {

        }
      ],
      taskDataSource:[],
      taskSize:10,
      taskQuery: {
        current: 1,
      },
      taskTotalCount:0,
      courseDataSource:[],
    };
  }
  componentDidMount() {
    
  }
  parsePlanColumns = () => {
    const columns = [
      {
        title: '培训计划名称',
        key: 'planInfo',
        dataIndex: 'planInfo',
        render: (val, record) => {
          return (
            <div>
              <div>
                <img src="https://image.xiaomaiketang.com/xm/YNfi45JwFA.png" style={{width:'100px',height:'50px'}}/>
              </div>
              <div>培训计划名称培训计划名称</div>
            </div>
          )
        }
      },
      {
        title: '学习进度',
        key: 'learnFinishNum',
        dataIndex: 'learnFinishNum',
        render: (val, record) => {
          return (
            <div>
              12%  
            </div>
          )
        }
      }
    ];
    return columns;
  }

  parseTaskColumns = () => {
    const columns = [
      {
        title: '培训任务',
        key: 'taskName',
        dataIndex: 'taskName',
        render: (val, record,index) => {
          return (
            <div>
              { size*10 + (index + 1) }.{val}
            </div>
          )
        }
      },
      {
        title: '学习进度',
        key: 'learnFinishPercentage',
        dataIndex: 'learnFinishPercentage',
        render: (val, record) => {
          return (
            <div>
              {val}%  
            </div>
          )
        }
      }
    ];
    return columns;
  }
  parseCoursecolumns = (parentIndex) => {
    const columns = [
      {
        title: '课程',
        key: 'courseName',
        dataIndex: 'courseName',
        render: (val, record,index) => {
          return (
            <div>
             
            </div>
          )
        }
      },
      {
        title: '学习进度',
        key: 'learnState',
        dataIndex: 'learnState',
        render: (val, record) => {
          return (
            <div>
              {val}%  
            </div>
          )
        }
      }
    ];
    return columns;
  }
  render() {
    const { planDataSource,taskDataSource,taskQuery,taskTotalCount} = this.state;
    const { visible } = this.props;
    return (
        <Modal
          title="用户学习详情"
          onCancel={this.props.onClose}
          maskClosable={false}
          visible={visible}
          className="user-Learn-modal"
          closable={true}
          width={800}
          closeIcon={<span className="icon iconfont modal-close-icon">&#xe6ef;</span>} 
        >
          <div>
            <span>
              <span>用户：</span>
              <span>巴扎黑</span>
            </span>
            <span>
              <span>手机号</span>
              <span>18226927277</span>
            </span>
          </div>
          <div>
           <Table
              rowKey={record => record.id}
              dataSource={planDataSource}
              columns={this.parsePlanColumns()}
              pagination={false}
              bordered
            />
          </div>
          <div>
            <Table
              rowKey={record => record.id}
              dataSource={taskDataSource}
              columns={this.parseTaskColumns()}
              pagination={false}
              bordered
              expandedRowRender={(record,index) => {
                if (record.courseList.length !== 0 ){
                  return  <div>
                            <Table
                              pagination={false}
                              dataSource={record.courseList}
                              columns={this.parseCoursecolumns(index)}
                              rowKey={record => record.id}
                            />
                      </div>
                }
              }}
            />
          </div>
        </Modal>
    )
  }
}

export default UserLearnDetailModal;