/*
 * @Author: 庞国铭
 * @Description: 学员审核列表 筛选
 */

import React, { useState } from 'react';

import { Row, Input, Tooltip } from 'antd';
import RangePicker from '@/modules/common/DateRangePicker';
import moment from 'moment';

import './WechatUserAuditFilter.less';

const { Search } = Input;

const defaultQuery = {
  realName: null,
  startDate: null,
  endDate: null,
};

const WechatUserAuditFilter = function (props) {
  const { onChange = () => {} } = props;
  const [query, setQuery] = useState(defaultQuery);

  // 改变搜索条件
  function handleChangeQuery(field, value) {
    let _query = {
      ...query,
      [field]: value,
      current: 1,
    };
    setQuery(_query);
    onChange(_query);
  }

  //日期选择
  function handleChangeDates(dates) {
    let _query = {
      ...query,
      current: 1,
    };

    if (_.isEmpty(dates)) {
      delete _query.startDate;
      delete _query.endDate;
    } else {
      _query.startDate = dates[0]?.startOf('day').valueOf();
      _query.endDate = dates[1]?.endOf('day').valueOf();
    }
    setQuery(_query);
    onChange(_query);
  }

  //重置
  function handleReset() {
    setQuery({
      ...defaultQuery,
      current: 1,
    });
    onChange(query);
  }

  return (
    <div className='wechat-user-audit-filter'>
      <Row type='flex' justify='space-between' align='top'>
        <div className='search-condition'>
          <div className='search-condition__item'>
            <span className='search-name'>搜索用户：</span>
            <Search
              value={query.realName}
              placeholder='搜索用户'
              onChange={(e) => {
                handleChangeQuery('realName', e.target.value);
              }}
              onSearch={() => {
                onChange(query.current);
              }}
              style={{ width: 'calc(100% - 81px)' }}
              className='search-input'
              enterButton={<span className='icon iconfont'>&#xe832;</span>}
            />
          </div>

          <div className='search-condition__item'>
            <span className='search-date'>申请时间：</span>
            <RangePicker
              id='course_date_picker'
              allowClear={false}
              value={query.startDate ? [moment(query.startDate), moment(query.endDate)] : null}
              format={'YYYY-MM-DD'}
              onChange={(dates) => {
                handleChangeDates(dates);
              }}
              style={{ width: 'calc(100% - 81px)' }}
            />
          </div>
        </div>

        <div className='reset-fold-area'>
          <Tooltip title='清空筛选'>
            <span className='resetBtn iconfont icon' onClick={handleReset}>
              &#xe61b;
            </span>
          </Tooltip>
        </div>
      </Row>
    </div>
  );
};

export default WechatUserAuditFilter;
