import React, { useEffect, useState } from "react";
import { withRouter } from "react-router-dom";
import { Input,Checkbox,Tooltip} from "antd";
import StoreService from "@/domains/store-domain/storeService";
import User from '@/common/js/user';
import WWOpenDataCom from '@/components/WWOpenDataCom';
import $  from 'jquery';
import _ from 'underscore';
import './SearchUser.less'
const { Search } = Input;
function SearchUser(props) {
  const [dropDownVisible,setDropDownVisible]=useState(false);
  useEffect(()=>{
    documentClick();
  },[])
  function onFocus(e){
    setDropDownVisible(true);
  }

  function onChange(e){
    setDropDownVisible(true);
    props.onChange(e.target.value)
  }
  function selectuser(e,item){
    if(e.target.checked){
      let _record = props.selectList
      _record.push(item)
      props.onSelect(_record,'user')
    }else{
      let _record = props.selectList
      _record.map((_item,index)=>{
        if(_item.userId === item.userId){
          _record.splice(index,1)
        }
      })
      props.onSelect(_record,'user') 
    }
  }
  function selectDep(e,item){
    console.log('item',item);
    if(e.target.checked){
      let _record   = props.selectList;
      let  _userList = []; 
      _record.push(item); // 将当前选中的部门塞进来
      if(item.departmentUserVOList){
        _userList = item.departmentUserVOList; //获取当前选中的人
      }
      _record = [..._record,..._userList];
      props.onSelect(_record,'department');
    }else{
      let _record = [];
      let  _userList = []; 
      props.selectList.map((_item,index)=>{
        if(_item.id !== item.id){   //取消选择后将当前的部门移除也要将父部门也移除
          _record.push(_item);
        }
      })
      if(item.departmentUserVOList){
        _userList = item.departmentUserVOList; //获取当前选中的人
      }
      const new_arr = _record.filter((x) => {return !_userList.some((item) => x.id === item.id)});
      // _userList.map((_item,index)=>{
      //   if(_item.id === item.id){
      //     _record.splice(_item,index);
      //   }
      // })
      props.onSelect(new_arr,'department');
    }
  }
  function  documentClick(){
    document.onclick = function (e) {
      let _con =$('#search-user');
      if(!_con.is(e.target) && _con.has(e.target).length === 0){
        setDropDownVisible(false);
      }
    };
  }

  function handleDepName(depArray){
    const depArrayDom = depArray.map((item, index) => {
    return <span><WWOpenDataCom type="departmentName" openid={item}/>；</span>
    });
    return depArrayDom;
  };
  return (
    <div className="search-user" style={{width:'300px'}} id="search-user">
        <Search 
          placeholder='搜索成员'
          enterButton={<span className="icon iconfont">&#xe832;</span>}
          onFocus={(e)=>{onFocus(e)}}
          onChange={(e)=>{onChange(e)}}
          className="search-input-item"
        />
        {dropDownVisible && 
        <div className="drop-down">
              <div className="drop-down__list">
                 {props.data.departmentUserVOList &&
                  ( props.data.departmentUserVOList.length>0 && <div className="drop-down__item-user">
                    <div className="drop-down__item__title">
                        员工 
                    </div>
                    <div className="drop-down__item__con">
                      <div>
                        {props.data.departmentUserVOList.map((item,index)=>{
                          return  <div>
                            <Checkbox onChange={(e)=>{selectuser(e,item)}} checked={_.pluck(props.selectList, 'userId').indexOf(item.userId)=== -1?false:true}>
                                <div className="drop-down__item__con__item">
                                  <div className="drop-down__item__con__item__left">
                                    <span className="icon iconfont title-icon">&#xe603;</span>
                                      <WWOpenDataCom type="userName" openid={item.userName}/>
                                  </div>
                                  <div className="drop-down__item__con__item__right">
                                    <Tooltip  title={<div>{handleDepName(item.depNamesList)}</div>} placement='top' arrowPointAtCenter>
                                      {item.depNamesList.map((_item,index)=>{
                                        return <span> <WWOpenDataCom type="departmentName" openid={_item}/>{index<(item.depNamesList.length -1)?';':''}</span>
                                        })
                                      }
                                      </Tooltip>
                                  </div>
                                </div>
                          </Checkbox>
                          </div>
                        })
                        }
                      </div>
                    </div>
                  </div>)
                }
                {props.data.departmentVOList  &&
                  (props.data.departmentVOList.length>0 && <div>
                    <div className="drop-down__item__title drop-down__item__title-dep">
                        部门
                    </div>
                    <div className="drop-down__item__con">
                      <div>
                        {props.data.departmentVOList.map((item,index)=>{    
                          return  <div><Checkbox onChange={(e)=>{selectDep(e,item)}} checked={_.pluck(props.selectList, 'id').indexOf(item.id)=== -1?false:true}>
                                      <div className="drop-down__item__con__item">
                                      <div className="drop-down__item__con__item__left">
                                        <Tooltip title={  <WWOpenDataCom type="departmentName" openid={item.name}/>}>
                                          <span className="departmentName">
                                            <WWOpenDataCom type="departmentName" openid={item.name}/>
                                          </span>
                                        </Tooltip>
                                      </div>
                                    </div>
                                </Checkbox>
                            </div>
                        })
                        }
                      </div>
                    </div>
                  </div>)
                }
                {(!props.data.departmentUserVOList && !props.data.departmentVOList)&&
                  <div className="empty-con">
                    <img src="https://image.xiaomaiketang.com/xm/wRDrb2pJFb.png" className="empty-img"/>
                    <div className="empty-text">暂无数据</div>
                  </div>
                }
                { (props.data.departmentUserVOList && props.data.departmentVOList) &&(
                  (props.data.departmentUserVOList.length === 0 && props.data.departmentVOList.length ===0) &&
                    <div className="empty-con">
                    <img src="https://image.xiaomaiketang.com/xm/wRDrb2pJFb.png" className="empty-img"/>
                    <div className="empty-text">暂无数据</div>
                  </div>
                 )
                }
              </div>
        </div>
        }
    </div>
  );
}

export default withRouter(SearchUser);
