import React, { useEffect, useState } from 'react';
import { withRouter } from "react-router-dom";
import { Progress } from 'antd';
import ENUM from '../../enum'
import moment from 'moment'
const defaultCover = 'https://image.xiaomaiketang.com/xm/rEAetaTEh3.png';

function DataInfo(props: any) {

    return <div className="infoBox">
        <div className="left">
            <div className="banner">
                <img src={ props.info.cover|| defaultCover} alt="" />
            </div>
            <div className="textBox">
                <div className="nameBox">
                    <div className="name">{props.info.taskName}</div>
                    <div className="status" style={{ color: ENUM.trainStatus[props.info.taskState || 'UN_START'].color, background: ENUM.trainStatus[props.info.taskState || 'UN_START'].background }}>{ENUM.trainStatus[props.info.taskState || 'UN_START'].text}</div>
                </div>
                <div className="info">
                    <span>  {`创建人: ${props.info.createName} `}</span>
                    <span style={{ marginLeft: 24 }}>  {`培训时间：${moment(props.info.startTime).format('YYYY-MM-DD HH:mm')} 至 ${moment(props.info.endTime).format('YYYY-MM-DD HH:mm')}`}</span>
                </div>
                <div className="info">
                    <div className="item">{`任务数:${props.info.contentNum}`}</div>
                    {
                        !!props.info.courseNum && <div className="item"><span className="icon"><img src="https://image.xiaomaiketang.com/xm/6C2GjSpnDp.png" alt="" /></span>{`课程：${props.info.courseNum}`}</div>
                    }

                    {/* <div className="item"><span className="icon"><img src="https://image.xiaomaiketang.com/xm/6C2GjSpnDp.png" alt="" /></span>{`作业：4`}</div> */}
                    {
                        !!props.info.examNum && <div className="item"><span className="icon"><img src="https://image.xiaomaiketang.com/xm/fCDPp2Eenc.png" alt="" /></span>{`考试：${props.info.examNum}`}</div>
                    }

                </div>
            </div>


        </div>
        <div className="right">
            <div className="prog">
                <Progress type="circle" width={85} percent={75} strokeWidth={10} format={percent => <div className='wcl'>{`${(parseInt(props.info.finishCustomerNum /(props.info.cultureCustomerNum)*100 as any))}% `}  <div>完成率</div></div>} />
            </div>
            <div className="num">
                <div className="item"> {`指派人数：${props.info.cultureCustomerNum}`}</div>
                <div className="item">{`学习人数：${props.info.cultureCustomerNum}`}</div>
                <div className="item">{`完成人数：${props.info.finishCustomerNum}`}</div>
            </div>
        </div>
    </div>
}

export default withRouter(DataInfo)