import React from 'react';
import { Modal } from 'antd';

import Service from '@/common/js/service';
import { DISK_MAP } from '@/domains/resource-disk/constants';

import FolderManage from './components/FolderManage';
import DiskList from './components/DiskList';

import './index.less';

const { gmtCreate } = window.currentUserInstInfo || {};

// 判断是新用户还是老用户（gmtCreate小于上线日期的话就是老用户）
const onlineDate = +new Date('2020-07-17 00:00:00');
const isOldUser = gmtCreate <= onlineDate;

const defaultRootDisk = {
  folderName: '我的文件',
  disk: 'MYSELF',
  uploadPower: false
}

class PrepareLessonPage extends React.Component {

  constructor(props) {
    super(props);
    const prepareLessonTips = localStorage.getItem('prepare_lesson_tips');
    this.state = {
      prepareLessonTips,
      diskList: [],                   // 可见磁盘目录
      currentRootDisk: defaultRootDisk
    }
  }

  componentWillMount() {
    this.handleFetchDiskList();
  }

  handleFetchDiskList = async () => {
    const res = await Service.Apollo('public/apollo/getUserDisk', {});
    const { result = [] } = res;
    const diskList = result.map((item) => {
      return {
        ...item,
        folderName: DISK_MAP[item.disk]
      }
    });
    this.setState({
      diskList,
      currentRootDisk: diskList[0] || defaultRootDisk
    });
  }

  handleChangeDisk = (disk) => {
    this.setState({
      currentRootDisk: disk
    });
  }

  render() {
    const { currentRootDisk, prepareLessonTips, diskList } = this.state;

    return (
      <div className="prepare-lesson-page page">
        <div className="content-header">资料云盘</div>
        <div className="box content-body">
          <DiskList
            diskList={diskList}
            currentRootDisk={currentRootDisk}
            onChange={this.handleChangeDisk}
          />
          <FolderManage
            currentRootDisk={currentRootDisk}
          />
        </div>

        {/* 老用户显示弹窗提示 */}
        <Modal
          title="备课本改版"
          visible={!prepareLessonTips && isOldUser}
          footer={null}
          width={680}
          maskClosable={false}
          className="prepare-lesson-upgrade-modal"
          onCancel={() => {
            this.setState({
              prepareLessonTips: true
            })
          }}
        >
          <div className="title">“备课本” 升级为 “资料云盘” 了！</div>
          <div className="upgrade-list">
            <div className="upgrade-list__item">
              <img src="https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/1594780611301.png" alt=""/>
              <div className="item-title">存储更便捷</div>
              <div className="item-sub-title">讲次关联模式升级文件夹模式，存储不再受讲次限制</div>
            </div>
            <div className="upgrade-list__item">
              <img src="https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/1594780629259.png" alt=""/>
              <div className="item-title">结构更清晰</div>
              <div className="item-sub-title">新增“我的文件”“公共文件”“员工文件”，满足机构存储需求</div>
            </div>
            <div className="upgrade-list__item">
              <img src="https://xiaomai-image.oss-cn-hangzhou.aliyuncs.com/1594780641665.png" alt=""/>
              <div className="item-title">同步更方便</div>
              <div className="item-sub-title">支持主管直接查看员工文件，优质资料一目了然</div>
            </div>
          </div>

          <div
            className="footer"
            onClick={() => {
              this.setState({ prepareLessonTips: true });
              localStorage.setItem('prepare_lesson_tips', true);
            }}
          >我知道了</div>
        </Modal>
      </div>
    )
  }
}

export default PrepareLessonPage;