import React from 'react';
import { Button, Modal, Select } from 'antd';

import './QRCodeModal.less';

const { Option } = Select;

export default class QRCodeModal extends React.Component {
  constructor(props) {
    super(props);
  }

  render() {
    const { visible, onCancel } = this.props;
    return (
      <Modal
        title="考勤二维码"
        width={560}
        visible={visible}
        footer={<Button onClick={() => onCancel()}>关闭</Button>}
        onCancel={() => onCancel()}
        className="offline-qrcode-modal"
      >
        <div>
          <Select
            style={{ width: 200 }}
            placeholder="请选择"
          >
            
          </Select>
          <Button
            type="primary"
            style={{ marginLeft: 8 }}
          >下载二维码</Button>
        </div>
        <div className="image-box">
          <img src="https://image.xiaomaiketang.com/xm/xYSpX2y6ri.png" className="image" />

        </div>
      </Modal>
    )
  }
}