import React from 'react';
import { Modal, TreeSelect } from 'antd';
import './MoveModal.less';

class MoveModal extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      categoryId: undefined,
    };
  }

  handleChangeCatalogList = (value, label) => {
    this.setState({ categoryId: value, categoryName: label[0] });
  };

  render() {
    const { visible, title, onCancel, onOk, data, length } = this.props;
    const { categoryId } = this.state;
    return (
        <Modal
          title={`移动${title}`}
          visible={visible}
          onCancel={onCancel}
          maskClosable={false}
          className="common-move-modal"
          onOk={() => onOk(categoryId)}
        >
          <div className="tip">
            <span className="icon iconfont">&#xe6f2;</span>
            <span className="text">已选择<span style={{ color: '#2966FF' }}>{length}</span>个{title}，移动后，原有分类将移除此{title}。</span>
          </div>
          <div className="move-item">
            <span className="label">选择分类：</span>
            <TreeSelect
              showSearch
              treeNodeFilterProp="title"
              style={{ width: 240 }}
              dropdownStyle={{ maxHeight: 220 }}
              treeData={data}
              placeholder="请选择分类"
              allowClear
              value={categoryId}
              onChange={(value, label) => {
                this.handleChangeCatalogList(value, label);
              }}
            />
          </div>
        </Modal>
    )
  }
}

export default MoveModal;