/*
 * @Author: 吴文洁
 * @Date: 2020-04-28 18:05:30
 * @LastEditors: wufan
 * @LastEditTime: 2020-12-02 11:37:13
 * @Description: 
 */
import mainRoutes from './config/mainRoutes';
import React  from 'react'
import { Redirect,HashRouter as Router,Route ,Switch} from 'react-router-dom';
import { createHashHistory } from 'history';
import App from '../modules/root/App';
import AppContext from '@/modules/root/AppContent';
import Login from '../modules/root/Login';
import _ from 'underscore';
import { asyncComponent } from 'react-async-component'
const history = createHashHistory();
window.RCHistory = _.extend({}, history, {
	push: (obj: any) => {
		history.push(obj)
	},
	pushState:  (obj: any) => {
		history.push(obj)
	},
	pushStateWithStatus: (obj: any) => {
		history.push(obj)
	},
	goBack: history.goBack,
    location: history.location,
	replace: (obj: any) => {
		history.replace(obj)
	}
});

const cache:any = {
	path: '',
	component: null
}

function dynamic (component:any) {
	const resolveComponent = component
	return asyncComponent({
		resolve: () => {
			const ts = resolveComponent()
			return ts
		},
	})
}

export const RootRouter = () => {
	return (
		<Router {...history}>
			<Switch>
				<Route key="1" exact path="/login" render={() => <Login />} />
				<Route key="2" path="/" render={() => <AppContext />} />
			</Switch>
		</Router>
	)
}
export const MainRoutes = () => {
	console.log("mainRoutes")
	return (
		<Switch>
			{
				_.map(mainRoutes, ({
					path,
					component,
				}, key) => {
					return <Route
						key={key}
						path={path}
						render={() => {
							const Component = component;
							return <Component />
						}}
					/>
				})
			}
		</Switch>
	)
}