import React from 'react';
import { Modal, Button } from 'antd';
import Cropper from 'react-cropper';
import 'cropperjs/dist/cropper.css';

class ImgCclipModal extends React.Component {
 
  render() {
    const {
      title = "设置图片",
      visible,
      onClose, 
      reUpload,
      modalWidth=1080,
      cutContentWidth,
      cutContentHeight,
      width = 550,
      needReUpload = false,
    } = this.props;
    return (
        <Modal
        title="设置图片"
        width={1080}
        visible={visible}
        maskClosable={false}
        closeIcon={<span className="icon iconfont modal-close-icon">&#xe6ef;</span>}
        onCancel={() => {
          this.setState({ visible: false });
        }}
        zIndex={10001}
        footer={[
          <Button
            key="back"
            onClick={() => {
              this.setState({ visible: false });
            }}
          >
            重新上传
          </Button>,
          <Button
            key="submit"
            type="primary"
            disabled={!hasImgReady}
            onClick={() => {
              const cutImg = this.state.cropperInstace.getCroppedCanvas().toDataURL();
              const cutImageBlob = this.convertBase64UrlToBlob(cutImg)
              this.getSignature(cutImageBlob);
            }}
          >
            确定
          </Button>,
        ]}
      >
        <div className="clip-box">
          <div
            style={{
              width: "500px",
              height: "430px",
              marginBottom: 0,
            }}
          >
           <Cropper
              style={{ height: 400, width:'100%'}}
              className="cropper__box"
              zoomTo={2}
              aspectRatio={16/9}
              preview=".preview-url-box"
              src='https://image.xiaomaiketang.com/xm/GEyiHbWB8W.png'
              viewMode={1}
              guides={true}
              background={false}
              responsive={true}
              autoCropArea={1}
              checkOrientation={false} 
              cropBoxResizable={false}
              onInitialized={(instance) => {
                this.setState({
                  cropperInstace:instance
                })
              }}
              ready={()=>{
                this.setState({
                  hasImgReady:true
                })
                this.state.cropperInstace.setCropBoxData({width:500,height:282})
                const that = this;
                document.querySelector('.cropper__box').addEventListener('dblclick', function (e) {
                  that.state.cropperInstace.rotate(90)
                });
              }}
            />
          </div>
          <div id="clipBtn" style={{ display: "none" }} ref="hiddenBtn"></div>
          <div className="preview-img">
            <div className="title">效果预览</div>
            <div id="preview-url-box" style={{width:'500px',height:'282px'}} className="preview-url-box">
             
            </div>
            <div className="tip-box">
              <div className="tip">温馨提示</div>
              <div className="tip">①预览效果图时可能存在延迟，单击左侧图片刷新即可</div>
              <div className="tip">②设置图片时双击可旋转图片，滚动可放大或缩小图片</div>
            </div>
          </div>
        </div>
      </Modal>
    )
  }
}

export default ImgCutModal;