import React from 'react';
import { Modal } from "antd";
import { XMVideoNew } from "@/components";
import "./ScanFileModal.less";
import { FileTypeIcon } from "@/common/constants/academic/lessonEnum";
import { Player, BigPlayButton } from "video-react";

class ScanFileModal extends React.Component {
  constructor(props) {
    super(props);
    this.state = {};
  }

  handleCancel = () => {
    this.props.close();
  };

  render() {
    const { fileType, item, modalTitle = "查看文件" } = this.props;
    return (
      <Modal
        visible={true}
        onCancel={this.handleCancel}
        title={modalTitle}
        footer={null}
        width={680}
        className="scan-file-modal"
      >
        <div className="scan-file-modal" style={{ width: 632 }}>
          {(fileType === "JPG" || fileType === 'PNG') && (
            <img
              src={item.ossAddress || item.ossUrl}
              style={{ width: 632, objectFit: "cover" }}
            ></img>
          )}
          {fileType === "MP4" && (
            <div>
              <Player
                src={item.ossAddress || item.ossUrl}
                fluid={false}
                height={306}
                width={"100%"}
              >
                <BigPlayButton position="center" />
              </Player>
              <video
                style={{ display: "none" }}
                ref="video"
                src={item.ossAddress || item.ossUrl}
                constrols="constrols"
                id="video"
              ></video>
            </div>
          )}
          {fileType === "MP3" && (
            <div className="scan-file-modal__mp3">
              <Player
                src={item.ossAddress || item.ossUrl}
                fluid={false}
                height={306}
                width={"100%"}
                autoPlay={true}
              >
                <BigPlayButton position="center" />
              </Player>
            </div>
          )}
        </div>
      </Modal>
    );
  }
}

export default ScanFileModal;
