/*
 * @Author: zhujian 
 * @Date: 2018-10-10 20:49:11 
 * @Last Modified by: zhujiapeng
 * @Last Modified time: 2020-11-16 17:02:11
 */

// import './s.less'
import React from 'react';
import Lottie from 'react-lottie';
import * as activity from '../lottie/activity/data.json';
import content from '../lottie/content/data.json';
import * as course from '../lottie/course/data.json';
import * as data from '../lottie/data/data.json';
import * as money from '../lottie/money/data.json';
import * as news from '../lottie/news/data.json';
import * as studentData from '../lottie/student/data.json';
import './DefaultIcon.less';

class DefaultIcon extends BaseComponent {
  constructor(props) {
    super(props);
    this.state = {
      data: {
        student: studentData,
        activity,
        data,
        money,
        news,
        content,
        course
      }
    }
  }

  render() {
    const defaultOptions = {
      loop: true,
      autoplay: true,
      animationData: this.state.data[this.props.type],
      rendererSettings: {
        preserveAspectRatio: 'xMidYMid slice'
      }
    }
    return (
      <div style={this.props.style}  className="DefaultIcon" key="icon">
        <Lottie
          options={defaultOptions}
          height={this.props.size||90}
          width={this.props.size ||90}
          isStopped={this.props.isStopped}
          isPaused={this.props.isPaused}
        />
        <div>{this.props.title }</div>
      </div>
    );
  }
}

export default DefaultIcon;