/*
 * @Author: yuananting
 * @Date: 2021-08-03 10:47:59
 * @LastEditors: yuananting
 * @LastEditTime: 2021-08-14 17:35:04
 * @Description: 编辑培训任务-失效课程
 * @Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React from 'react';
import { List, message, Modal } from 'antd';
import './ExpiredCourseList.less';
import ENUM from '../../enum';
import moment from 'moment';
import TaskCenterService from '@/domains/task-center-domain/TaskCenterService';

function ExpiredCourseList(props) {
  // 移除未成功开课课程
  function deLExpiredCourse(contentId) {
    Modal.confirm({
      content: '你确定要删除该数据内容吗？',
      okText: '取消',
      cancelText: '确定',
      icon: <span className='icon iconfont default-confirm-icon'>&#xe6f4;</span>,
      onOk: () => {
        const params = {
          taskId: window.getParameterByName('taskId'),
          contentId: [contentId],
        };

        TaskCenterService.deLExpiredCourse(params).then((res) => {
          message.success('删除成功');
        });
      },
    });
  }

  return (
    <div className='expired-list-page'>
      <div className='tip'>为了不影响学员学习，「未成功开课」的课程已从任务中移出，具体课程如下所示：</div>
      <List
        dataSource={props.expiredCourseList}
        renderItem={(item) => (
          <List.Item>
            <div className='item-detail'>
              <span className='icon iconfont'>&#xe80b;</span>
              <span className='content-status'>未成功开课</span>
              <span className='stage-name'>{item.stageName}</span>
              <span className='content-name'>
                <img src={ENUM.LearningContentIcon[item.courseType]} />
                <span>{item.courseName}</span>
              </span>
              <span className='teacher-name'>{item.teacherName}</span>
              <span className='split'>|</span>
              <span className='course-time'>
                {moment(item.startTime).format('YYYY-MM-DD HH:mm')}~{moment(item.endTime).format('HH:mm')}
              </span>
              <span
                className='del-btn'
                onClick={() => {
                  deLExpiredCourse(item.courseId);
                }}>
                删除记录
              </span>
            </div>
          </List.Item>
        )}
      />
    </div>
  );
}

export default ExpiredCourseList;
