import React from 'react';
import { Modal, Button } from "antd";
import "./StartLiveModal.less"
class StartLiveModal extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      download: "",
      downloadMac: "",
      protocol: "",
      protocolMac: ""
    };
  }

  componentDidMount() {
    this.fetchLaunchInfo();
  }

  fetchLaunchInfo = () => {
    const param = {
      liveCourseId: this.props.liveCourseId
    };
    window.axios.Apollo('public/businessLive/courseLaunch', param).then(res => {
      const { result } = res;
      this.setState({
        download: result.download,
        downloadMac: result.downloadMac,
        protocol: result.protocol,
        protocolMac: result.protocolMac,
      });
    })
  }

  downloadAPP = () => {
    const { download, downloadMac } = this.state;
    if (!download || !downloadMac) {
      return;
    }
    const isMac = /macintosh|mac os x/i.test(navigator.userAgent);
    const aTag = document.createElement('a');
    document.body.appendChild(aTag);
    if (isMac) {
      aTag.href = encodeURI(downloadMac);
    } else {
      aTag.href = encodeURI(download);
    }
    aTag.target = '_blank';
    aTag.click();
    document.body.removeChild(aTag);
    this.props.close();
  }

  launchApp = () => {
    const { protocol, protocolMac } = this.state;
    if (!protocol || !protocolMac) {
      return;
    }
    const isMac = /macintosh|mac os x/i.test(navigator.userAgent);
    const aTag = document.createElement('a');
    document.body.appendChild(aTag);
    if (isMac) {
      aTag.href = encodeURI(protocolMac);
    } else {
      aTag.href = encodeURI(protocol);
    }
    aTag.target = '_blank';
    aTag.click();
    document.body.removeChild(aTag);
  }

  render() {
    return (
      <Modal
        title="开始直播"
        visible={true}
        width={550}
        footer={null}
        maskClosable={false}
        onCancel={this.props.close}
      >
        <div className="live-start-modal">
         <img  src="https://image.xiaomaiketang.com/xm/K2sJJHG3pa.png" alt="" className="live-img"></img>
          <div className="live-text">
            <p className="live-title">没有安装直播客户端</p>
            <p className="live-instruction">首次上课需要下载云直播客户端，请先下载并安装。</p>
          </div>
          <Button type="primary" className="live-btn" onClick={this.downloadAPP}>立即下载</Button>
        </div>
        <div className="live-start-modal">
         <img  src="https://image.xiaomaiketang.com/xm/wPwRdaa7MM.png" alt="" className="live-img"></img>
          <div className="live-text">
            <p className="live-title">已安装直播客户端</p>
            <p className="live-instruction">已安装云直播客户端，请直接启动上课</p>
          </div>
          <Button type="primary" className="live-btn" onClick={this.launchApp}>开始直播</Button>
        </div>
      </Modal>
    );
  }
}

export default StartLiveModal;
