/*
 * @Author: wufan
 * @Date: 2020-11-30 10:47:38
 * @LastEditors: wufan
 * @LastEditTime: 2020-11-30 17:35:24
 * @Description: 员工管理页面
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */

import React, { useEffect, useState } from "react";
import { withRouter } from "react-router-dom";
import _ from "underscore";
import PageControl from "@/components/PageControl";
import {
  Table,
  Modal,
  message,
  Row,
  Col,
  Input,
  DatePicker,
  Button,
} from "antd";
import { QuestionCircleOutlined } from "@ant-design/icons";
import StoreService from "@/domains/store-domain/storeService";

import "./StoreDecorationPage.less";
import moment from "moment";
const { confirm } = Modal;
const { Search } = Input;
const { RangePicker } = DatePicker;

declare var window: any;

interface RecordTypes {
  storeUserId: string;
  role: string;
}

function StoreDecorationPage() {
  const [storeDecorationlist, setStoreDecorationlist] = useState([
    {
      name: "赵云",
      phone: "18767118672",
      role: "0",
      storeUserId: "",
    },
    {
      name: "吕布",
      phone: "18767118672",
      role: "0",
      storeUserId: "",
    },
  ]);
  const [query, setQuery] = useState({
    current: 0,
    size: 10,
    name: "",
    phone: "",
    identity: "ALL",
    instId: "1837447" || window.currentUserInstInfo.instId,
    registerStartDate: null,
    registerEndDate: null,
  });
  const [total, setTotal] = useState(0);
  const [model, setModel] = useState(null);
  const [isModalOpen, setIsModalOpen] = useState(false);
  const [isManager, setIsManager] = useState(true);
  const [isNormal, setIsNormal] = useState(true);
  const [choosedItem, setChooseItem] = useState({});

  useEffect(() => {
    // getStoreDecorationList();
  }, [query]);

  function getStoreDecorationList() {
    let _query = _.clone(query);
    _query.current = query.current + 1;
    StoreService.getStoreDecorationList(_query).then((res: any) => {
      console.log(res.result.records);
      setStoreDecorationlist(res.result.records);
      setTotal(res.result.total);
    });
  }

  function handleReplaceDecoration(record: RecordTypes) {}

  function handleDeleteDecoration(record: RecordTypes) {}

  function handleDeleteDecorationConfirm(record: RecordTypes) {
    return confirm({
      title: "你确定要删除这个banner吗？",
      icon: <span className="icon iconfont default-confirm-icon">&#xe839; </span>,
      okText: "删除",
      cancelText: "取消",
      onOk: () => {
        handleDeleteDecoration(record);
      },
    });
  }

  function parseColumn() {
    return [
      {
        title: "用户姓名",
        dataIndex: "name",
        render: (val: string) => {
          return (
            <div className="coupon-info">
              <span className="title">{val}</span>
            </div>
          );
        },
      },
      {
        title: "手机号",
        dataIndex: "phone",
        key: "phone",
        render: (val: string) => {
          return <div>{val}</div>;
        },
      },
      {
        title: "注册时间",
        dataIndex: "registerDate",
        key: "registerDate",
        render: (val: string) => {
          return <div>{moment(val).format("YYYY-MM-DD HH:mm:ss")}</div>;
        },
      },
      {
        title: "操作",
        dataIndex: "operation",
        render: (val: string, record: RecordTypes) => {
          return record.role === "" || record.role === "1" ? (
            <div className="no-operate">-</div>
          ) : (
            <div className="operation">
              <span
                className="edit"
                onClick={() => handleReplaceDecoration(record)}
              >
                替换
              </span>
              <span className="divider-line">{" | "}</span>
              <span
                className="delete"
                onClick={() => handleDeleteDecoration(record)}
              >
                删除
              </span>
            </div>
          );
        },
      },
    ];
  }

  function handleQuery(name: string, value: any) {
    const _query = _.clone(query);
    // _query[name] = value;
    setQuery(_query);
  }

  function handleToAddStoreDecoration() {}

  return (
    <div className="page user-manage-page">
      <div className="page-content">
        <div className="content-header">店铺装修</div>
        <div className="box">
          <div className="box-header">
            <div
              style={{
                display: "flex",
                alignItems: "center",
                justifyContent: "space-between",
                padding: "15px 0 10px",
              }}
            >
              <div style={{ flex: 1 }}>banner设置</div>
            </div>
            <Button
              onClick={() => {
                handleToAddStoreDecoration();
              }}
              type="primary"
              className="add-show-btn"
            >
              添加Banner
            </Button>
          </div>
          <div className="box-body">
            <Table
              size={"middle"}
              pagination={false}
              dataSource={storeDecorationlist}
              columns={parseColumn()}
              rowKey={(item: any) => item.id}
              bordered
            />
          </div>
          <div className="box-footer">
            <PageControl
              current={query.current}
              pageSize={query.size}
              total={total}
              toPage={(page) => {
                const queryStates = _.clone(query);
                queryStates.current = page;
                setQuery(queryStates);
              }}
            />
          </div>
        </div>
      </div>
    </div>
  );
}

export default withRouter(StoreDecorationPage);
