/*
 * @Author: yuananting
 * @Date: 2021-08-05 11:26:25
 * @LastEditors: yuananting
 * @LastEditTime: 2021-08-13 10:57:19
 * @Description: 个人学习详情-全部tab页
 * @Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 * @@Copyrigh: © 2020 杭州杰竞科技有限公司 版权所有
 */
import React, { useState, useEffect } from 'react';
import { Collapse, Progress } from 'antd';
import './WholeData.less';
import ENUM from '../../enum';
const { Panel } = Collapse;

function WholeData(props) {
  const SortConvert = ['一', '二', '三', '四', '五', '六', '七', '八', '九', '十'];

  const courseStateShow = {
    UN_START: {
      title: '待开播',
    },
    STARTING: {
      title: '直播中',
    },
    FINISH: {
      title: '回放',
    },
    EXPIRED: {
      title: '未成功开课',
    },
  };

  const [stageCustomerList, setStageCustomerList] = useState([]);

  useEffect(() => {
    setStageCustomerList(props.detail.stageCustomerVOList);
  }, [props]);

  // 渲染阶段信息
  function renderStageInfo(item, index) {
    return (
      <div className='stage-info__item'>
        <span className='stage-name'>
          {SortConvert[index]}、{item.stageName}
        </span>
        <span className='extra-info'>
          （{item.learnFinishNum}/{item.learnAllNum}）
        </span>
      </div>
    );
  }

  // 渲染学习内容信息

  function renderContentInfo(contentItem, contentIndex, index) {
    const { contentName, contentType, courseChapterNum, courseState, learnFinishPercentage } = contentItem;
    return (
      <div className='content-info__item'>
        <div className='basic-info'>
          <img src={ENUM.LearningContentIcon[contentType]} />
          <span className='content-name'>
            {contentIndex + 1}.{index + 1} {contentName}
          </span>
          {contentType === 'LIVE' && <span className='extra-info'>{courseStateShow[courseState].title}</span>}
          {contentType === 'VOICE' && <span className='extra-info'>（共{courseChapterNum || 1}小节）</span>}
        </div>
        <div className='percent-info'>
          {learnFinishPercentage === 100 ? (
            <span className='icon iconfont'>&#xe621;</span>
          ) : (
            <Progress
              width={20}
              strokeWidth={12}
              type='circle'
              trailColor='#EAEAEA'
              strokeColor={{
                '0%': '#38B7F3',
                '100%': '#1A80E2',
              }}
              percent={learnFinishPercentage}
            />
          )}
          <span className='text'>{learnFinishPercentage === 100 ? '已完成' : `${learnFinishPercentage}%`}</span>
        </div>
      </div>
    );
  }

  return (
    <div className='whole-data-container'>
      <Collapse ghost>
        {stageCustomerList?.length > 0 &&
          stageCustomerList.map((item, index) => {
            return (
              <Panel header={renderStageInfo(item, index)} key={index}>
                {item.contentVOList.map((contentItem, contentIndex) => {
                  return renderContentInfo(contentItem, contentIndex, index);
                })}
              </Panel>
            );
          })}
      </Collapse>
    </div>
  );
}

export default WholeData;
