/*
 * @Author: zhujian
 * @Date: 2019-07-24 13:38:39
 * @Last Modified by: 孙冰清
 * @Last Modified time: 2019-07-25 14:19:26
 */

import React from 'react';
import { Button } from 'antd';

interface ButtonProps {
  prefixCls?: 'xm-btn';
  disabled?: false;
  size?: any;
  style?: any;
  icon?: null;
  iconPosition?: 'left';
  title?: 'Button';
  onClick?: any;
  id?: string;
  children?: any;
  type?: any;
}

const XMButton = (props: ButtonProps) => {
  const { size, style, disabled, title, onClick, id, children, type} = props;
  let clickStatus = false;

  function _onClick(): void {
    if (clickStatus) {
      return;
    }
    
    clickStatus = true;
    onClick && onClick();
    
    setTimeout(() => {
      clickStatus = false;
    }, 1000);
  }

  return (
    <Button type={type}  style={style}  id={id} size={size} disabled={disabled} onClick={_onClick} >{title || children}</Button>
  );
};

export default XMButton;
