import React, { Key, useContext, useEffect, useRef, useState } from 'react';
import {
  withRouter,
} from 'react-router-dom';
import { Menu} from 'antd';
import { menuList } from '../../routes//config/menuList'
import { XMContext } from '../../store/context';
import Service from "@/common/js/service";
import StoreService from "@/domains/store-domain/storeService";
import User from "@/common/js/user";
import _ from 'underscore';
import "./Menu.less";

const { SubMenu } = Menu;
function Aside(props: any) {
  const {menuType,handleMenuType}= props
  const ctx: any = useContext(XMContext);
  const [selectKey, setSelectKey] = useState();
  const [openKeys, setOpenKeys] = useState(['']);
  const [lastOpenKeys, setLastOpenKeys] = useState(['']);
  const [topLogoUrl, setTopLogoUrl] = useState("")
  const [collapsed, setCollapsed] = useState(false)
  const rootSubmenuKeys = _.pluck(menuList, 'groupCode');
  useEffect(() => {
    const link = props.location.pathname;
    menuList.map((item: any, index: any) => {
      if (link.indexOf(item.link) !== -1) {
        setSelectKey(item.groupCode);
        setOpenKeys([])
        setLastOpenKeys([])
      } else if (item.children) {
        item.children.map((_item: any, _index: any) => {
          if (link.indexOf(_item.link) !== -1) {
            setSelectKey(_item.groupCode + index + _index);
          }
        })
      }
      return item;
    })
  }, [props.location.pathname])
  useEffect(()=> {
    getTopLeftLogo()
  },[])
  function getTopLeftLogo() {
    if (User.getToken()) {
      StoreService.getStoreDetail({storeId:User.getStoreId()})
      .then(res=> {
        if (_.isEmpty(res.result.logo)) {
          setTopLogoUrl("https://image.xiaomaiketang.com/xm/fe4NCjr7XF.png")
        } else {
          setTopLogoUrl(res.result.logo)
        }
        
      })
    }
  }
  function toggleMenu(item: any) {
    window.RCHistory.push(item.link)
    // if (!menuType) {
    //   setOpenKeys([])
    // }
  }
  function onOpenChange(key: Key[]) {
    if (typeof key === "string") {
      if (openKeys.includes(key)) {
        setOpenKeys([]);
        setLastOpenKeys([]);
      } else {
        setOpenKeys([key]);
        setLastOpenKeys([key])
      }
    }
  }

  function onOpenChangeForHover(key: Key[]) {
    if (menuType) {
      return
    }
    if (typeof key === "string") {
      if (openKeys.includes(key)) {
        setOpenKeys([]);
        setLastOpenKeys([]);
      } else {
        setOpenKeys([key]);
        setLastOpenKeys([key])
      }
    }
  }

  function handleMenu() {
    handleMenuType();
    setCollapsed(!collapsed)
    if (!collapsed) {
      setOpenKeys([])
    } else {
      setOpenKeys(lastOpenKeys)
    }
  }

  return (
    <div 
        id="left-container"
        className={
          menuType
            ? "left-container"
            : "left-container left-container-vertical"
        }
      >
        <div className="top-ctrl">
        <div className="topLogo">
          { menuType && <img src={topLogoUrl} alt="" className="img1"></img> }
        </div>
        <div className="menu-type-icon"  onClick={handleMenu}>
          {menuType ? (
            <span
              className="icon iconfont"
            >
              &#xe83d;
            </span>
          ) : (
            <span
              className="icon iconfont"
            >
              &#xe615;
            </span>
          )}
        </div>
        </div>
        
        <div className="left">
          <div className="nav">

        <Menu
          style={{ minHeight: "100%", background: '#0E1935' }}
          selectedKeys={selectKey}
          openKeys={openKeys}
          onOpenChange={onOpenChange}
          inlineCollapsed={collapsed}
          mode={menuType ? "inline" : "vertical"}
        >
          {
            menuList.map((item: any, index: any) => {
              if (ctx.xmState.storeUserPermissionList.indexOf(item.groupCode) === -1) {
                return null;
              }
              if (item.children) {
                return <SubMenu 
                        key={item.groupCode} 
                        style={{ marginTop: 0 }} 
                        title={<div><img src={item.img} className="icon-img"></img><span>{item.groupName}</span></div> } 
                        onTitleClick={() => onOpenChange(item.groupCode)}
                        onTitleMouseEnter={()=> onOpenChangeForHover(item.groupCode)}
                        >
                  {
                    item.children.map((_item: any, _index: any) => {
                      if (ctx.xmState.storeUserPermissionList.indexOf(_item.groupCode) === -1) {
                        return null;
                      }
                      return <Menu.Item onClick={() => { toggleMenu(_item) }} style={{ marginTop: 0 }} key={_item.groupCode + index + _index} onMouseLeave={()=> onOpenChangeForHover(item.groupCode)}>
                        <span className="name">{_item.groupName}</span>
                      </Menu.Item>

                    })
                  }
                </SubMenu>
              } else {
                return <Menu.Item 
                        onClick={() => { toggleMenu(item) }} 
                        key={item.groupCode} 
                        icon={selectKey === item.groupCode ? <img src={item.selectImg} className="icon-img"></img>:<img src={item.img} className="icon-img"></img>}
                        >
                    {menuType ? item.groupName : ""}
                </Menu.Item>
              }
            })
          }
        </Menu>
      </div>
      </div>
    </div>
  );
}

export default withRouter(Aside);