import React from 'react';
import { Modal, Button, Radio } from 'antd';
import './SetEmployeeModal.less'

const RadioGroup = Radio.Group;
const tagMap = {
  Cloud_Operator: '运营师',
  Cloud_Lecturer: '讲师',
  Cloud_Manager: '管理员',
}

export default class SetEmployeeModal extends React.Component {
  constructor(props) {
    super(props);
    const list = props.list.map(item => ({ ...item, roleCode: item.enterpriseRole === 'ADMIN' ? 'Cloud_Manager' : 'Cloud_Lecturer' }))
    const selectedData = list[0] || {};
    this.state = {
      list,
      selected: selectedData.enterpriseVisibleUserId,
      roleCode: selectedData.roleCode,
    }
  }

  handleChangeValues(value) {
    const { list, selected } = this.state;
    list.map((item) => {
      if (item.enterpriseVisibleUserId === selected) {
        item.roleCode = value;
      }
    })
    this.setState({ roleCode: value, list });
  }

  render() {
    const {
      list,
      roleCode,
      selected,
    } = this.state;
    return (
      <Modal
        visible={true}
        title="添加员工"
        className="set-employee-modal"
        onOk={() => {

        }}
        onCancel={() => {

        }}
        wenterpriseVisibleUserIdth={680}
        footer={
          <div className="modal-footer">
            <Button style={{ float: 'left' }}>上一步</Button>
            <Button>取消</Button>
            <Button type="primary">确定</Button>
          </div>
        }
      >
        <div className="employee-container">
          <div className="employee-box">
            {list.map((item) => (
              <div
                className={`item ${selected === item.enterpriseVisibleUserId ? ' selected' : ''}`}
                key={item.enterpriseVisibleUserId}
                onClick={() => this.setState({ selected: item.enterpriseVisibleUserId })}
              >
                <span className="icon iconfont avatar-icon">&#xe84a;</span>
                <span className='name'>{item.name}</span>
                <span className="tag">{tagMap[item.roleCode]}</span>
            </div>
            ))}
          </div>
          <div className="detail-box">
            <div className="title">员工身份：</div>
            <RadioGroup
              value={roleCode}
              onChange={(e) => {
                this.handleChangeValues(e.target.value);
              }}
              className="mt5"
            >
              <Radio value={"Cloud_Operator"} className="mt-4">
                <span style={{ color: "#333" }}>运营师</span>
                <p className="radio-tip">
                  仅可查看/转发培训计划内容，并查看负责的用户学习进度
                </p>
              </Radio>
              <Radio value={"Cloud_Lecturer"} className="mt-4">
                <span style={{ color: "#333" }}>讲师</span>
                <p className="radio-tip">
                  仅可查看/使用与自己相关的文件和课表，并进行上课
                </p>
              </Radio>
              <Radio value={"Cloud_Manager"}>
                <span style={{ color: "#333" }}>管理员</span>
                <p className="radio-tip">可执行学院中所有的操作</p>
              </Radio>
            </RadioGroup>
          </div>
        </div>
      </Modal>
    )
  }
}