import React from 'react';
import { Row, Radio } from 'antd';
const WechatUserAuditOpt = function (props) {
  const { onChange = () => {}, listCount = {}, defaultType = '' } = props;
  const { allCnt = 0, passedCnt = 0, rejectedCnt = 0, waitCnt = 0 } = listCount;
  return (
    <div className='wechat-user-audit-filter'>
      <Row type='flex' justify='end' align='top'>
        <Radio.Group onChange={(e) => onChange({ applyStatus: e.target.value })} defaultValue={defaultType}>
          <Radio.Button value=''>{`全部(${allCnt})`}</Radio.Button>
          <Radio.Button value='WAIT'>{`待审核(${waitCnt})`}</Radio.Button>
          <Radio.Button value='PASSED'>{`已通过(${passedCnt})`}</Radio.Button>
          <Radio.Button value='REJECTED'>{`已拒绝(${rejectedCnt})`}</Radio.Button>
        </Radio.Group>
      </Row>
    </div>
  );
};
export default WechatUserAuditOpt;
