import React from 'react';
import E from 'wangeditor';
import Bus from '../../../core/bus';
import './GraphicsEditor.less';

const { BtnMenu } = E;

class ImageMenu extends BtnMenu {
  constructor(editor) {
    // data-title属性表示当鼠标悬停在该按钮上时提示该按钮的功能简述
      const $elem = E.$(
          `<div class="w-e-menu" data-title="图片">
              <i class="w-e-icon-image"></i>
          </div>`
      )
      super($elem, editor)
  }
  // 菜单点击事件
  clickHandler() {
    Bus.trigger('graphicsEditorImage')
  }

  tryChangeActive() {
    
  }
}

class VideoMenu extends BtnMenu {
  constructor(editor) {
    // data-title属性表示当鼠标悬停在该按钮上时提示该按钮的功能简述
      const $elem = E.$(
          `<div class="w-e-menu" data-title="视频">
              <i class="w-e-icon-play"></i>
          </div>`
      )
      super($elem, editor)
  }
  // 菜单点击事件
  clickHandler() {
    Bus.trigger('graphicsEditorVideo')
  }

  tryChangeActive() {
    
  }
}

class GraphicsEditor extends React.Component {
  constructor(props) {
    super(props)
    this.state = {
      editorId: window.random_string(16),
      textLength: 0,
    }
    this.editorInt = null;
  }

  componentDidMount() {
    this.renderEditor()
    this.resetIndex(true);
  }

  componentWillReceiveProps(nextProps) {
    const { content } = this.props.detail;
    const { content: nextContent } = nextProps.detail;
    const videoCount = ((content || '').match(/<iframe/g) || []).length;
    const nextVideoCount = ((nextContent || '').match(/<iframe/g) || []).length;
    const imageCount = ((content || '').match(/<img/g) || []).length;
    const nextImageCount = ((nextContent || '').match(/<img/g) || []).length;
    if ((videoCount !== nextVideoCount) || (imageCount !== nextImageCount)) {
      this.editorInt && this.editorInt.txt.html(nextProps.detail.content);
    }
  }

  componentWillUnmount() {
    this.resetIndex();
  }

  resetIndex = (bool) => {
    const topDom = document.querySelector('.top-container');
    const leftDom = document.querySelector('.left-container');
    topDom.style.zIndex = bool ? 'auto' : 112;
    leftDom.style.zIndex = bool ? 'auto' : 2;
  }

  renderEditor() {
    const { editorId } = this.state;
    const { detail, onChange, isIntro } = this.props;
    this.editorInt = new E(`#editor${editorId}`);
    this.editorInt.config.showFullScreen = !isIntro
    this.editorInt.menus.extend('xmimage', ImageMenu);
    this.editorInt.menus.extend('xmvideo', VideoMenu);
    this.editorInt.config.menus = isIntro ?
      [
        'head',
        'bold',
        'fontSize',
        'fontName',
        'italic',
        'underline',
        'strikeThrough',
        'foreColor',
        'backColor',
        'list',
        'justify',
        'emoticon',
        'xmimage',
      ]
      : [
        'head',
        'bold',
        'fontSize',
        'fontName',
        'italic',
        'underline',
        'strikeThrough',
        'indent',
        'lineHeight',
        'foreColor',
        'backColor',
        'link',
        'list',
        'todo',
        'justify',
        'quote',
        'emoticon',
        'xmimage',
        'xmvideo',
        'table',
        'code',
        'splitLine',
        'undo',
        'redo',
      ];

    this.editorInt.config.emotions = [
      {
        title: 'emoji',
        type: 'emoji',
        content: ['😀', '😃', '😄', '😁', '😆', '😅', '😂', '😊', '🙂', '🙃', '😉', '😓', '😅', '😪', '🤔', '😬', '🤐']
      }
    ]
    this.editorInt.config.zIndex = 1;
    this.editorInt.config.pasteFilterStyle = false;
    this.editorInt.config.pasteIgnoreImg = true;
    // 自定义处理粘贴的文本内容
    this.editorInt.config.pasteTextHandle = function (content) {
      if (content == '' && !content) return ''
      var str = content
      str = str.replace(/<xml>[\s\S]*?<\/xml>/ig, '')
      str = str.replace(/<style>[\s\S]*?<\/style>/ig, '')
      str = str.replace(/[ | ]*\n/g, '\n')
      str = str.replace(/\&nbsp\;/ig, ' ')
      return str
    }
    this.editorInt.config.onchange = (html) => {
      const textLength = this.editorInt.txt.text().replace(/\&nbsp\;/ig, ' ').length;
      this.setState({ textLength }, () => {
        onChange(html, this.state.textLength);
      })
    }
    this.editorInt.create();
    this.editorInt.txt.html(detail.content);
  }

  render() {
    const { editorId, textLength } = this.state;
    const { limitLength = 1000 } = this.props;
    return <div className="wang-editor-container ">
      <div className="editor-box" id={`editor${editorId}`}></div>
      {textLength > limitLength && <div className="editor-tips">超了{textLength - limitLength}个字</div>}
    </div>
  }
}

export default GraphicsEditor;
