/*
 * @Author: 吴文洁 
 * @Date: 2020-07-15 17:44:24 
 * @Last Modified by: mikey.zhaopeng
 * @Last Modified time: 2020-11-23 22:06:33
 * @Description: 添加直播课-上课信息
 */

import React from 'react';
import {
  Radio, Slider, Row, Input, InputNumber,
  DatePicker, TimePicker, Select, Button,
  message, Spin, Tooltip
} from 'antd';

// import TeacherSelectV5 from "@/modules/classManage_V5/classDetail/TeacherSelectV5";

import ChargeExplainModal from '../modal/ChargeExplainModal';
import SelectStudent from '../modal/select-student/index';
// import MultipleDatePicker from '@/modules/class/MultipleDatePicker';
import moment from 'moment';
import './AddLiveClass.less';

const defaultQuery = {
  // instId,
  size: 10,
  current: 1,
  adminName: null
}

// const { instId } = window.currentUserInstInfo;

class AddLiveClass extends React.Component {

  constructor(props) {
    super(props);
    this.state = {
      loading: false,
      hasNext: false,
      isUltimateEdition: false, // 是否是旗舰版
      query: defaultQuery,
      assistantList: [],     // 助教老师列表
      _assistantList: [],
      addLiveType: props.addLiveType
    }
  }

  componentWillMount() {
    const { liveScene } = this.props;
    // 如果是互动班课，则请求用户是否是旗舰版
    if (liveScene === 'interactive') {
      this.handleFetchPermission();
    }
    this.getAssistantList();
  }
  componentWillReceiveProps(nextProps) {
    if(nextProps.data.assistant.sort().toString() !== this.props.data.assistant.sort().toString()) {
      // 获取助教老师列表
      this.getAssistantList(1, nextProps.data.assistant);
    }
  }
  // 获取用户是否是旗舰版的权限
  handleFetchPermission = () => {
    // const { instId } = window.currentUserInstInfo;
    this.setState({ loading: true });
    axios.Business('public/inst/checkInstProduct', {
      // instId: instId || LS.get("instId"),
      productCodeList: ['ULTIMATESELL', 'PIP_TO_ULTIMATE', 'HIGH_TO_ULTIMATE']
    }).then((res) => {
      const { result } = res;
      this.setState({
        loading: false,
        isUltimateEdition: result,
        // 旗舰版用户没有大班直播模式，所以默认是大班互动模式
        addLiveType: result ? 'LARGE_CLASS_INTERACTION' : 'LARGE_CLASS_LIVE'
      })
    });
  }

  // 获取助教老师列表
  getAssistantList = (current = 1, selectList) => {
    // const { query, assistantList } = this.state;
    // const { selectedAssistant } = this.props;
    // const { teacherId, assistant } = this.props.data;
    // const idList = selectList ? selectList : assistant;
    // const _query = {
    //   ...query,
    //   current,
    //   idList,
    //   size: idList.length <= 10 ? 10 : idList.length + 10
    // };
    // this.setState({ query: _query });
    // axios.Apollo("public/businessLive/queryAdminByName", _query).then((res) => {
    //   const { result = {} } = res;
    //   const { records = [], total = 0, hasNext } = result;
    //   const list = current > 1 ? assistantList.concat(records) : records;
    //     const _assistantList = _.uniq(
    //       selectedAssistant.concat(
    //         _.reject(list, (item) => item.id === teacherId)
    //       ),
    //       false,
    //       (item) => item.id
    //     );
    //     this.setState({
    //       hasNext,
    //       assistantList: list,
    //       _assistantList: _assistantList
    //     })
        
      
    // });
  }

  // 修改直播模式
  handleChangeLiveType = (e) => {
    this.setState({
      addLiveType: e.target.value,
    });
    this.props.onChange('liveType', e.target.value);
  };

  //查看计费说明
  handleLookExplain = () => {
    const explainModal = (
      <ChargeExplainModal
        close={() => {
          this.setState({
            explainModal: null,
          });
        }}
      />
    );
    this.setState({ explainModal });
  };
  
  // 滑动加载更多
  handleScroll = (e) => {
    console.log('srcoll')
    const { hasNext } = this.state;
    const container = e.target;
    const scrollToBottom = container &&  container.scrollHeight <= container.clientHeight + container.scrollTop;
    if (scrollToBottom && hasNext) {
      const { query } = this.state;
      this.getAssistantList(query.current + 1);
    }
  }

  // 选择学员数量
  handleShowSelectStuModal = (studentType) => {
    const {
      after,
      liveScene,
      data: {
        id,
        studentList,
        consumeStudentList,
        excludeStudentIds,
        excludeConsumeStudentIds,
      }
    } = this.props;

    const { savedSelectedRows } = this.state;

    const studentModal = (
      <SelectStudent
        savedSelectedRows={savedSelectedRows}
        studentType={studentType}
        liveScene={liveScene}
        after={after} //表明是不是上课后的状态
        excludeStudentIds={excludeStudentIds}
        excludeConsumeStudentIds={excludeConsumeStudentIds}
        studentList={studentList}
        consumeStudentList={consumeStudentList}
        close={() => {
          this.setState({
            studentModal: null,
          });
        }}
        onSelect={(studentIds, selectedStudents, savedSelectedRows) => {
          this.setState({ savedSelectedRows })
          this.handleSelectStudent(studentIds, selectedStudents, studentType)
        }}
      />
    )

    this.setState({ studentModal });
  }

  handleSelectStudent = (studentIds, selectedStudents = [], studentType) => {
    let studentList = [];
    if (studentType === 'DEDUCTION') {
      studentList = selectedStudents
    } else {
      _.each(studentIds, (item) => {
        studentList.push({ studentId: item });
      });
    }

    const {
      liveScene,
      liveType,
      endTime,
      startTime,
      id,
      podium,
      excludeStudentIds,
      excludeConsumeStudentIds
    } = this.props.data;
    const { addLiveType } = this.state;

    // 当前选择的学员
    const currentSelectStuIds = studentType === 'DEDUCTION' ? _.pluck(selectedStudents, 'studentId') : studentIds;
    // 如果当前选择的是扣课时学员，那么总的已选学员人数 = 扣课时 + 之前选择不扣课时的
    // 如果当前选择的是不扣课时学员，那么总的已选学员人数 = 不扣课时 + 之前选择的扣课时的
    const prevSelectStutIds = studentType === 'DEDUCTION' ? excludeStudentIds : excludeConsumeStudentIds;
    const studentLen = [...currentSelectStuIds, ...prevSelectStutIds].length;

    // 如果是互动班课，模式为大班直播，学员人数超过1000人，提示最多选择1000人
    // 如果是大班直播（大班直播没有模式，只要考虑学员人数是否超过了1000个人即可）
    if ((liveScene === 'interactive' &&
      addLiveType !== "SMALL_CLASS_INTERACTION" &&
      studentLen > 1000) || (studentLen > 1000)
    ) {
      message.info(`最多选择1000人`);
      return;
      // 如果是互动班课，模式为大班互动，学员人数超过课上台人数，提示最多选择上台人数
    } else if (liveScene === 'interactive' &&
      addLiveType === "SMALL_CLASS_INTERACTION" &&
      studentLen > podium
    ) {
      message.info(`最多选择${podium}人`);
      return;
    }

    this.setState({ studentModal: null });
    if (studentType === 'DEDUCTION') {
      this.props.onChange('consumeStudentList', studentList);
    } else {
      this.props.onChange('studentList', studentList);
    }
  }

  disabledDate = (current) => {
    return current.valueOf() < moment().subtract(1, "days")
  };

  selectMultiDate = (calendarTime) => {
    this.setState({
      calendarTime
    })
  }
  render() {
    const {
      loading,
      assistantList,
      addLiveType,
      isUltimateEdition,
      query,
      _assistantList
    } = this.state;
    // pageType: 页面类型：add->新建、edit->编辑
    // liveScene: 直播场景: interactive -> 互动班课 large -> 大班直播
    // data：表单数据
    // selectedAssistant: 已经选择的助教
    const { pageType, liveScene, data, selectedAssistant, isXiaomai, isEdit, after } = this.props;
    const {
      podium,
      endTime,
      liveType,
      liveDate,
      assistant,
      startTime,
      teacherId,
      studentList,
      teacherName,
      timeHorizonEnd,
      consumeHourNum,
      consumeClassTime,
      timeHorizonStart,
      consumeStudentList,
      applyMode,
      calendarTime
    } = data;
    // 已选择的上课学员数量(不扣课时)
    const hasSelectedStu = studentList.length;

    // 已选择的上课学员数量(扣课时)
    const hasSelectedDeductionStu = consumeStudentList.length;

    return (
      <Spin spinning={loading}>
        <div className="add-live__class-info">
          {
            liveScene === 'interactive' &&
            <div className="live-mode">
              <span className="label">直播模式：</span>
              {
                pageType === 'add' ?
                <Radio.Group
                  className="uncommon-wrapper"
                  onChange={this.handleChangeLiveType}
                  value={addLiveType}
                >
                  {
                    // 旗舰版不显示大班互动
                    !isUltimateEdition &&
                    <Radio
                      value={"LARGE_CLASS_LIVE"}
                    >
                      <p className="title">
                        { window.ENUM.liveType["LARGE_CLASS_LIVE"].name }
                      </p>
                      <p className="info">
                        { window.ENUM.liveType["LARGE_CLASS_LIVE"].info }
                      </p>
                    </Radio>
                  }

                  <Radio
                    value={"LARGE_CLASS_INTERACTION"}
                  >
                    <p className="title">
                      { window.ENUM.liveType["LARGE_CLASS_INTERACTION"].name }
                    </p>
                    <p className="info">
                      { window.ENUM.liveType["LARGE_CLASS_INTERACTION"].info }
                    </p>
                  </Radio>

                  <Radio
                    value={"SMALL_CLASS_INTERACTION"}                          
                  >
                    <p className="title">
                      { window.ENUM.liveType["SMALL_CLASS_INTERACTION"].name }
                    </p>
                    <p className="info">
                      { window.ENUM.liveType["SMALL_CLASS_INTERACTION"].info }
                    </p>
                  </Radio>
                </Radio.Group> :
                <div className="edit-info">
                  <p className="name">
                    {window.ENUM.liveType[liveType].name}
                  </p>
                  <p className="info">
                    {window.ENUM.liveType[liveType].info}
                  </p>
                </div>
              }
            </div>
          }

          {
            liveScene === 'interactive' && 
            addLiveType !== "LARGE_CLASS_LIVE" &&
            pageType === 'add' &&
            <div className="stage-num">
              <div className="content">
                <span className="label">上台人数：</span>
                  <Row type="flex">
                    <Slider
                      min={1}
                      max={12}
                      style={{ width: 160 }}
                      className="add-live-slider"
                      onChange={(value) => {
                        this.props.onChange('podium', Number(value));
                      }}
                      value={typeof podium === "number" ? podium : 1}
                    />

                    <Input
                      style={{ margin: "0 16px", width: 90 }}
                      value={podium}
                      onChange={(e) => {
                        const { value } = e.target;
                        this.props.onChange('podium', parseInt(value));
                      }}
                      onBlur={(e) => {
                        let value = e.target.value;
                        if (value < 1) {
                          value = 1;
                        } else if (value > 12) {
                          value = 12;
                        }
                        value = value ? parseInt(value) : value;
                        this.props.onChange('podium', value);
                      }}
                    />
                  </Row>
                </div>  
              <div className="tips">
                请按需选择同时上台的最多人数，人数越多价格越贵，设置后不可修改。
                <span
                  className="look-explain"
                  onClick={this.handleLookExplain}
                >
                  查看计费规则
                </span>
              </div>
            </div>
          }

          {
            liveScene === 'interactive' &&
            addLiveType !== "LARGE_CLASS_LIVE" &&
            pageType === "edit" &&
            <div className="podium-max-num">
              <span className="label">上台人数：</span>
              <span>最多可同时上台{podium}人</span>
            </div>
          }
          {
            window.NewVersion && pageType === 'add' &&
            <div className="course">
              <div className="day">
                <span className="label">
                  <span className="require">*</span>
                    上课日期
                    <Tooltip 
                      overlayStyle={{maxWidth: 300, zIndex: '9999'}} 
                      title={<div style={{width: '266px'}}>支持按上课日期批量创建直播课，创建后按“课程名称_日期”命名，例如：<br/>张三的语文课_9月18日<br/>张三的语文课_9月19日......</div>}>
                      <span className="iconfont">&#xe6f2;</span>
                    </Tooltip>：
                  </span>
                <div>
                  <div className='select-day'>
                    已选 
                    <span class="mark-day">
                      {isLongArr(calendarTime)
                        ? calendarTime.length : 0
                      }
                    </span> 天
                  </div>
                  {/* <MultipleDatePicker
                    selectDateList={calendarTime}
                    onSelect={this.selectMultiDate}
                    canSelectTodayBefore={false}
                  /> */}
                </div>
                
              </div>
              
              <div className="hour" id="hour">
                <span className="label"><span className="require">*</span>上课时间：</span>
                <TimePicker
                  format="HH:mm"
                  value={startTime ? moment(startTime) : null}
                  placeholder="开始时间"
                  style={{ width: 100, minWidth: 100}}
                  onChange={(time) => {
                    this.props.onChange('startTime', time);
                  }}
                />&nbsp;&nbsp;~&nbsp;&nbsp; 
                <TimePicker
                  format="HH:mm"
                  value={endTime ? moment(endTime) : null}
                  placeholder="结束时间"
                  style={{ width: 100, minWidth: 100 }}
                  onChange={(time) => { 
                    this.props.onChange('endTime', time)
                  }} 
                />
              </div>
            </div>
           
          }
          {
            (window.NewVersion && pageType !== 'add' || !window.NewVersion) && 
            <div className="time" id="time">
            <div className="content">
              <span className="label"><span className="require">*</span>上课时间：</span>
              <DatePicker
                disabled={liveScene === 'large' && !isEdit}
                format="YYYY-MM-DD"
                value={liveDate ? moment(Number(liveDate)) : null}
                style={{ width: 160, minWidth: 130, marginRight: 10 }}
                placeholder="上课日期"
                getCalendarContainer={() =>
                  document.getElementById("time")
                }
                disabledDate={this.disabledDate}
                onChange={(date) => { this.props.onChange('liveDate', date) }}
              />
              <TimePicker
                disabled={liveScene === 'large' && !isEdit}
                format="HH:mm"
                value={timeHorizonStart ? moment(Number(timeHorizonStart)) : null}
                defaultOpenValue={moment(new Date().setHours(0,0,0,0))}
                placeholder="开始时间"
                style={{ width: 100, minWidth: 100, marginRight: 10 }}
                getPopupContainer={() =>
                  document.getElementById("time")
                }
                onChange={(time) => { this.props.onChange('timeHorizonStart', time) }}
              />
              <TimePicker
                disabled={liveScene === 'large' && !isEdit}
                format="HH:mm"
                value={timeHorizonEnd ? moment(Number(timeHorizonEnd)) : null}
                defaultOpenValue={moment(new Date().setHours(0,0,0,0))}
                placeholder="结束时间"
                style={{ width: 100, minWidth: 100 }}
                getPopupContainer={() =>
                  document.getElementById("time")
                }
                onChange={(time) => { this.props.onChange('timeHorizonEnd', time) }}
              />
            </div>
            
          </div>
          }
          {
              liveScene === 'interactive' &&
              <div className="tips">
                上课老师可以在 直播时 主动结束直播
              </div>
            }
          <div className="teacher">
            <span className="label"><span className="require">* </span>上课老师：</span>
            {/* <TeacherSelectV5
              disabled={liveScene === 'large' && !isEdit}
              ref="TeacherSelect"
              showSearch={true}
              allowClear={true}
              onSelect={(teacherId, dataSet) => { this.props.onChange('teacherId', teacherId, dataSet) }}
              placeholder="请选择上课老师"
              defaultValue={teacherId}
              style={{ width: 240, marginTop: 6 }}
            /> */}
          </div>

          {
            isXiaomai &&
            <div className="assistant-teacher">
              <span className="label">助教老师：</span>
              <Select
                id="assistant"
                disabled={liveScene === 'large' && !isEdit}
                mode="multiple"
                value={assistant}
                placeholder="请选择助教老师"
                style={{ width: 240, marginTop: 6 }}
                filterOption={(input, option) => option}
                onPopupScroll={this.handleScroll}
                onChange={(value) => {
                  this.props.onChange('assistant', value) 
                }}
                onSearch={(value) => {
                  query.adminName = value
                  this.setState({
                    query
                  }, () => {
                    this.getAssistantList()
                  })
                }}
                onBlur={() => {
                  query.adminName = ''
                  this.setState({
                    query
                  }, () => {
                    this.getAssistantList()
                  })  
                }}
              >
                {_.map(_assistantList, (item, index) => {
                  return (
                    <Select.Option value={item.id} key={item.id}>{item.adminName}</Select.Option>
                  );
                })}
              </Select>
            </div>
          }
          {
            liveScene === 'large' && 
            <div className="watch-setting">
            <span className="label"><span className="require">* </span>分享设置：</span>
            <div className="content">
              <Radio.Group
                onChange={(e) => this.props.onChange('applyMode', e.target.value)}
                value={applyMode}
              >
                <Radio value={'ANYONE'}>
                  <div className="radio-item">
                    <div className="text mr16">允许任何学员通过直播课链接加入学习</div>
                    <div className="sub-text">加入后，在读学员可通过家长端、“每课学堂”app、直播课网页端、直播课链接观看，非在读学员仅可通过直播课链接观看</div>
                  </div>
                </Radio>

                <Radio value={'ONLY_READ'}>
                  <div className="radio-item">
                    <div className="text mr16">仅在读学员可通过直播课链接加入学习</div>
                    <div className="sub-text">加入后，在读学员可通过家长端、“每课学堂”app、直播课网页端、直播课链接观看</div>
                  </div>
                </Radio>

                <Radio value={'ASSIGN'}>
                  <div className="radio-item mb0">
                    <div className="text mr16">仅指定学员可通过直播课链接加入学习</div>
                    <div className="sub-text">加入后，在读学员可通过家长端、“每课学堂”app、直播课网页端、直播课链接观看</div>
                  </div>
                </Radio>
              </Radio.Group>
            </div>
          </div>
          }
          {
            window.NewVersion && isXiaomai ?
              <div className="class-student">
                <span className="label">上课学员：</span>
                <div className="class-student-content">
                  <div className="deduction-student">
                    <span className="label">扣课时学员：</span>
                    <div className="content">
                      <div className="has-selected">
                        已选择 <span style={{ color: "#FF8534" }}>{hasSelectedDeductionStu}</span>名学员
                        <Button onClick={() => this.handleShowSelectStuModal('DEDUCTION')}>选择学员</Button>
                      </div>
                    </div>
                  </div>

                  <div className="deduction-student-tips">
                    学员“到课”后，系统自动扣
                    <InputNumber
                      disabled={liveScene === 'large' && !isEdit}
                      min={0.1}
                      max={10}
                      precision={1}
                      value={consumeHourNum}
                      onChange={(value) => {
                        this.props.onChange('consumeHourNum', value)
                      }}
                      onBlur={(e) => {
                        this.props.onChange('consumeHourNum', e.target.value || 1)
                      }}
                    />课时
                  </div>
                  <div className="no-deduction-student">
                    <span className="label">不扣课时学员：</span>
                    <div className="content">
                      <div className="has-selected">
                        已选择 <span style={{ color: "#FF8534" }}>{hasSelectedStu}</span>名学员
                      </div>
                      <Button onClick={this.handleShowSelectStuModal}>选择学员</Button>
                    </div>
                  </div>
                </div>
              </div> :
            <div className="student">
                <span className="label">上课学员：</span>
                <div className="content">
                  <div className="has-selected">
                    已选择 <span style={{ color: "#FF8534" }}>{hasSelectedStu}</span>名学员
                  </div>
                  <Button onClick={this.handleShowSelectStuModal}>选择学员</Button>
                </div>
              </div>
          }
          {
            isXiaomai &&
            <div className="arrive-rule">
              <span className="label"><span className="require">* </span>到课规则：</span>
              学员累计在线时长达到
                <InputNumber
                  className="arrive-rule-input"
                  disabled={liveScene === 'large' && !isEdit}
                  min={0}
                  max={999}
                  precision={0}
                  value={consumeClassTime}
                  onChange={(value) => {
                    this.props.onChange('consumeClassTime', value)
                  }}
                  onBlur={(e) => {
                    this.props.onChange('consumeClassTime', e.target.value || 30)
                  }}
                />
                分钟，则视为学员”到课“
            </div>
          }

          { this.state.studentModal }
          { this.state.explainModal }
        </div>
      </Spin>
    )
  }
}

export default AddLiveClass;