import React, { useState, useRef, useEffect, useContext } from 'react'
import { Route, withRouter } from 'react-router-dom';
import Breadcrumbs from "@/components/Breadcrumbs";
import UserData from './UserData';
import ExamData from './ExamData'
import Service from "@/common/js/service";
import { Tabs } from 'antd';
import User from "@/common/js/user";
import './dataAnalysic.less'

const { TabPane } = Tabs;


function DataAnalysic(props: any) {
    const examDetailInit: any = {};
    const [selectKey, setSelectKey] = useState('user')
    const [examDetail, setExamDetail] = useState(examDetailInit);
    const { match } = props;
    const examId =match.params.id;

    useEffect(() => {
        queryExamDetail();
    }, [])
    
    function queryExamDetail() {
        Service.Hades("public/hades/queryExamDetail", {
            examId:examId,
            tenantId: User.getStoreId(),
            userId: User.getStoreUserId(),
            source: 0
        }).then((res) => {
            const { result } = res
            setExamDetail(result)
    
        })
    }

    return <div className="page dataAnalysic">
        <Breadcrumbs navList={"考试数据"} goBack={props.history.goBack} />
        <div className="box">
            <div className="titleBox ">
                <span className='tips'></span>
                考试名称：{examDetail.examName}
            </div>
        </div>
        <div className="box">
            <Tabs activeKey={selectKey} onChange={(key: any) => {
                setSelectKey(key)
            }}>
                <TabPane tab="考试人员数据" key="user">
                    <UserData  examDetail ={examDetail } examId={examId} />
                </TabPane>
                <TabPane tab="题目数据" key="exam">
                    <ExamData examDetail ={examDetail } examId={examId}></ExamData>
                </TabPane>

            </Tabs>
        </div>
    </div>
}


export default withRouter(DataAnalysic);