/**
 * 处理一个学员，报名同一个包月课多次  的时间计算
 * @param courseList
 * @returns {*}
 */
import domtoimage from 'dom-to-image'
import { Popover } from 'antd'
import React from 'react'
import $ from 'jquery';

// 时间控件优化方法
window.setCorrectDate = date => {
  let _date = date;

  if ((date - (+new Date()) < 30 * 60 * 1000)) {
    const currentMinute = new Date().getMinutes();

    if (currentMinute > 30) {
      _date = moment().add(60 - currentMinute, 'minute');
    } else {
      _date = moment().add(30 - currentMinute, 'minute');
    }
  }
  return _date;
}

// 优化四舍五入方法
if (!Number.prototype.toFixedCorrect) {
  Number.prototype.toFixedCorrect = function (n) {
    return Math.round((this * Math.pow(10, n)).toFixed(10) * 1) / Math.pow(10, n);
  }
}

window.processMonthCourseDate = courseList => {
  if (Array.isArray(courseList) && courseList.length > 0) {
    // 因为所购买的时间不可能有重叠，先排序
    courseList = courseList.sort(function (now, next) {
      return parseInt(now.startDate) - parseInt(next.startDate)
    })

    // 总天数，与已完成天数
    let sumDays = 0,
      finishDays = 0,
      givingDays = 0
    courseList.forEach(function (item) {
      if (item.endDate != item.purchaseEndDate) {
        givingDays += moment(parseInt(item.endDate)).diff(
          parseInt(item.purchaseEndDate),
          'days'
        )
      }

      const temp =
        moment(parseInt(item.endDate)).diff(parseInt(item.startDate), 'days') +
        1
      sumDays += temp
      if (item.endDate < Date.now()) {
        finishDays += temp
      } else if (item.startDate < Date.now() && Date.now() < item.endDate) {
        finishDays += moment().diff(parseInt(item.startDate), 'days') + 1
      }
    })
    let date = {}
    for (let i = 0, len = courseList.length; i < len; i++) {
      const course = courseList[i],
        nextCourse = courseList[i + 1]
      const startDate = (course.startDate = moment(parseInt(course.startDate))
        .startOf('day')
        .valueOf())
      const purchaseEndDate = (course.purchaseEndDate = moment(
        parseInt(course.purchaseEndDate)
      )
        .endOf('day')
        .valueOf())
      const endDate = (course.endDate = course.endDate
        ? moment(parseInt(course.endDate))
          .endOf('day')
          .valueOf()
        : undefined)

      if (i == 0 && Date.now() < startDate) {
        date = {
          startDate: startDate,
          endDate: endDate,
          purchaseEndDate: purchaseEndDate,
          text: '课程未开始'
        }
        break
      }
      if ((i == len - 1 && endDate < Date.now()) || !endDate) {
        date = {
          text: '课程到期',
          startDate: startDate,
          endDate: endDate,
          purchaseEndDate: purchaseEndDate
        }
        break
      }

      if (startDate < Date.now() && Date.now() < endDate) {
        date = {
          startDate: startDate,
          endDate: endDate,
          purchaseEndDate: purchaseEndDate,
          text: '课程进行中'
        }
        break
      } else if (
        endDate < Date.now() &&
        Date.now() < parseInt(nextCourse.startDate)
      ) {
        date = {
          startDate: parseInt(nextCourse.startDate),
          endDate: parseInt(nextCourse.endDate),
          purchaseEndDate: parseInt(nextCourse.purchaseEndDate),
          text: '课程未开始'
        }
        break
      }
    }
    // 总天数
    date.sumDays = sumDays
    // 已过去天数
    date.finishDays = finishDays
    // 剩余总天数
    date.subDays = sumDays - finishDays
    // 赠送天数
    date.givingDays = givingDays
    // 购买天数
    date.purchaseDays = sumDays - givingDays
    return date
  }
  return false
}

/**
 * 生成树
 * @param parentCode
 * @param datas
 * @param level
 * @returns {Array}
 */
window.createTree = (parentCode, datas, level = 0) => {
  const child = []
  const childCodes = []

  // 找子节点
  for (let i in datas) {
    const item = datas[i]
    if (item.parent == parentCode) {
      item.level = level
      child.push(item)
      childCodes.push(item.code)
    }
  }

  const len = child.length

  if (len > 0) {
    if (parentCode != 0) {
      datas[parentCode].child = child
      datas[parentCode].childCodes = childCodes
    }
    for (let i = 0; i < len; i++) {
      createTree(child[i].code, datas, level + 1)
    }
  }
  return child
}

window.sortPermission = data => {
  data.sort((a, b) => {
    return a.sequence - b.sequence
  })
  for (let i = 0; i < data.length; i++) {
    if (data[i].child) {
      window.sortPermission(data[i].child)
    }
  }
  return data
}

/**
 * 生成指定长度的随机字符串
 * @param len
 * @returns {string}
 */
window.random_string = len => {
  len = len || 32
  const chars = 'ABCDEFGHJKMNPQRSTWXYZabcdefhijkmnprstwxyz2345678'
  const maxPos = chars.length
  let pwd = ''
  for (let i = 0; i < len; i++) {
    pwd += chars.charAt(Math.floor(Math.random() * maxPos))
  }
  return pwd
}

/**
 * 金额转大写
 * @param num
 * @returns {string|*}
 */
window.numberToChines = num => {
  if (num != 0 && !num) return ''
  let strOutput = ''
  let strUnit = '仟佰拾亿仟佰拾万仟佰拾元角分'
  num += '00'
  const intPos = num.indexOf('.')
  if (intPos >= 0) num = num.substring(0, intPos) + num.substr(intPos + 1, 2)
  strUnit = strUnit.substr(strUnit.length - num.length)
  for (let i = 0; i < num.length; i++)
    strOutput +=
      '零壹贰叁肆伍陆柒捌玖'.substr(num.substr(i, 1), 1) + strUnit.substr(i, 1)
  return strOutput
    .replace(/零角零分$/, '整')
    .replace(/零[仟佰拾]/g, '零')
    .replace(/零{2,}/g, '零')
    .replace(/零([亿|万])/g, '$1')
    .replace(/零+元/, '元')
    .replace(/亿零{0,3}万/, '亿')
    .replace(/^元/, '零元')
}
/**
 * 人名币格式
 * @param price 人名币
 *
 */
window.getMoneyFormat = price => {
  if (!_.isNumber(Number(price))) {
    return '0.00'
  }
  const n = parseFloat(Math.round(price) / CONFIG.moneyUnit).toFixed(2)
  const re = /(\d{1,3})(?=(\d{3})+(?:\.))/g
  return n.replace(re, '$1,')
}

window.getNumberFormat = price => {
  const n = price + ''
  let arr = n.split('.')
  if (arr[1]) {
    arr[1] = arr[1].substring(0, 2)
  }
  arr.splice(2)
  return arr.join('.')
}
/**
 * 人名币转化为分
 * @param price 人名币
 *
 */

window.getMoneyByMoneyUnit = price => {
  return Math.round(price * CONFIG.moneyUnit)
}
/**
 * 时间格式
 * @param format 时间格式
 * @param timestamp  时间戳
 */

window.formatTime = (format, timestamp) => {
  if (!timestamp) {
    return
  }
  const date = new Date(parseInt(timestamp))
  let y = date.getFullYear(),
    m = date.getMonth() + 1,
    d = date.getDate(),
    h = date.getHours() - 8,
    i = date.getMinutes(),
    s = date.getSeconds(),
    w = date.getDay()
  return format
    .replace('YYYY', y)
    .replace('MM', m)
    .replace('DD', d)
    .replace('H', h)
    .replace('i', i)
    .replace('s', s)
}

window.formatDate = (format, timestamp) => {
  if (!timestamp) return ''

  if (timestamp == 0) return ''

  const date = new Date(parseInt(timestamp))
  let y = date.getFullYear(),
    m = date.getMonth() + 1,
    d = date.getDate(),
    h = date.getHours(),
    i = date.getMinutes(),
    s = date.getSeconds(),
    w = date.getDay(),
    week = ['周日', '周一', '周二', '周三', '周四', '周五', '周六']

  m = m < 10 ? '0' + m : m
  d = d < 10 ? '0' + d : d
  h = h < 10 ? '0' + h : h
  i = i < 10 ? '0' + i : i
  s = s < 10 ? '0' + s : s
  return format
    .replace('YYYY', y)
    .replace('MM', m)
    .replace('DD', d)
    .replace('H', h)
    .replace('i', i)
    .replace('s', s)
    .replace('WW', week[w])
}

/**
 * 查询字符串参数
 * @returns {Object}
 * @constructor
 */
window.getRequest = () => {
  const url = window.location.search //获取url中"?"符后的字串
  const theRequest = {}
  if (url.indexOf('?') != -1) {
    const str = url.substr(1)
    const strs = str.split('&')
    for (var i = 0; i < strs.length; i++) {
      theRequest[strs[i].split('=')[0]] = unescape(strs[i].split('=')[1])
    }
  }
  return theRequest
}

window.getParameterByName = function (name) {
  name = name.replace(/[\\[]/, '\\[').replace(/[\]]/, '\\]')
  const regex = new RegExp('[\\?&]' + name + '=([^&#]*)')
  const results = regex.exec(window.location.href)
  return results === null
    ? ''
    : decodeURIComponent(results[1].replace(/\+/g, ' '))
}

window.getUrlParam = function () {
  const urlArr = window.location.href.split('/');
  const str = urlArr[urlArr.length - 1];
  const param = parseInt(str);

  return isNaN(param) ? '' : str;
}

window.getStringParamete = function (string, name) {
  const theRequest = {}
  if (string.indexOf('?') != -1) {
    const str = string.substr(1)
    const strs = str.split('&')
    for (var i = 0; i < strs.length; i++) {
      theRequest[strs[i].split('=')[0]] = decodeURIComponent(strs[i].split('=')[1])
    }
  }
  return theRequest[name]
}

/**
 * dataURL 转 Blob
 * @param dataurl
 * @returns {Blob}
 */
window.dataURLtoBlob = dataurl => {
  const arr = dataurl.split(','),
    mime = arr[0].match(/:(.*?);/)[1],
    bstr = atob(arr[1]),
    u8arr = new Uint8Array(n)
  let n = bstr.length
  while (n--) {
    u8arr[n] = bstr.charCodeAt(n)
  }
  return new Blob([u8arr], {
    type: mime
  })
}

window.timeFormat = (time, defaultValue) => {
  const stringTime = time
    ? (time / CONFIG.timeUnit).toFixed(2)
    : defaultValue == undefined
      ? 0
      : defaultValue

  return Number(stringTime)
}

window.stringCompare = (s1, s2) => {
  if (!(s1 && s2)) {
    return true
  }
  const s1Arr = s1.split('.')
  const s2Arr = s2.split('.')
  var s1Num = 0
  var s2Num = 0
  var flag = true

  s1Arr.map((item, index) => {
    s1Num += item * Math.pow(10, 6 - 2 * index)
  })

  s2Arr.map((item, index) => {
    s2Num += item * Math.pow(10, 6 - 2 * index)
  })

  return !(s1Num < s2Num)
}

window.timeFormatSixty = (time, defaultValue) => {
  const stringTime = time
    ? (time / 60).toFixed(2)
    : defaultValue == undefined
      ? 0
      : defaultValue

  return Number(stringTime)
}

window.type = obj => {
  var toString = Object.prototype.toString
  var map = {
    '[object Boolean]': 'boolean',
    '[object Number]': 'number',
    '[object String]': 'string',
    '[object Function]': 'function',
    '[object Array]': 'array',
    '[object Date]': 'date',
    '[object RegExp]': 'regExp',
    '[object Undefined]': 'undefined',
    '[object Null]': 'null',
    '[object Object]': 'object'
  }
  return map[toString.call(obj)]
}

window.deepClone = data => {
  var self = this
  var t = type(data),
    o,
    i,
    ni

  if (t === 'array') {
    o = []
  } else if (t === 'object') {
    o = {}
  } else {
    return data
  }

  if (t === 'array') {
    for (i = 0, ni = data.length; i < ni; i++) {
      o.push(deepClone(data[i]))
    }
    return o
  } else if (t === 'object') {
    for (i in data) {
      o[i] = deepClone(data[i])
    }
    return o
  }
}

window.moneyFormat = (money, defaultValue) => {
  const stringMoney = money
    ? (Math.round(money) / CONFIG.moneyUnit).toFixed(2)
    : defaultValue == undefined
      ? 0
      : defaultValue
  return Number(stringMoney)
}

//格式化金额为千位加逗号
window.moneyFormatThousands = (number, places, symbol, thousand, decimal) => {
  number = number || 0
  places = !isNaN((places = Math.abs(places))) ? places : 2
  symbol = symbol !== undefined ? symbol : ''
  thousand = thousand || ','
  decimal = decimal || '.'
  let negative = number < 0 ? '-' : '',
    i = parseInt((number = Math.abs(+number || 0).toFixed(places)), 10) + '',
    j = i.length > 3 ? (i.length) % 3 : 0
  return (
    symbol +
    negative +
    (j ? i.substr(0, j) + thousand : '') +
    i.substr(j).replace(/(\d{3})(?=\d)/g, '$1' + thousand) +
    (places
      ? decimal +
      Math.abs(number - i)
        .toFixed(places)
        .slice(2)
      : '')
  )
}

/**
 * js数字精度转换
 */
window.formatFloat = (f, digit = 2) => {
  const m = Math.pow(10, digit)
  return Math.round(f * m, 10) / m
}

/**
 * 分钟数转成小时表示
 * @param number
 * @returns {string}
 */
window.intToHours = number => {
  //如果的整数
  let hours
  let minutes
  if (number % 1 == 0) {
    hours = Math.floor(number / 60)
    minutes = number % 60
  }
  hours = hours < 10 ? '0'.concat(hours) : hours
  minutes = minutes < 10 ? '0'.concat(minutes) : minutes

  return hours + ':' + minutes
}

window.getMonthLastDate = timestamp => {
  const date = new Date(parseInt(timestamp))
  const y = date.getFullYear()
  const m = date.getMonth() + 2
  let time = y + '-' + m + '-01'
  time = new Date(time).getTime() - 1000
  return time
}

window.formatHourTime = (timestr) => {
  const h = Math.floor(timestr / 1000 / 60 / 60);
  const m = Math.floor((timestr - h * 1000 * 60 * 60) / 1000 / 60);
  const s = Math.floor((timestr - h * 1000 * 60 * 60 - m * 1000 * 60) / 1000);
  return `${h > 9 ? h : ('0' + h)}:${m > 9 ? m : ('0' + m)}:${s > 9 ? s : ('0' + s)}`
}


/*
  获取日期相差多少天
* */
window.getSubDays = (endDate, startDate) => {
  return Math.ceil(
    moment(parseInt(endDate)).diff(moment(parseInt(startDate))) / 86400000
  )
}

window.getPlusMonths = (startDate, plusMonths) => {
  let dtTmp = new Date(parseInt(startDate))
  plusMonths = parseInt(plusMonths)
  return (
    new Date(
      dtTmp.getFullYear(),
      dtTmp.getMonth() + plusMonths,
      dtTmp.getDate(),
      dtTmp.getHours(),
      dtTmp.getMinutes(),
      dtTmp.getSeconds()
    ).getTime() - 1000
  )
}

window.getReduceMonths = (endDate, reduceMonths) => {
  let dtTmp = new Date(parseInt(endDate));

  reduceMonths = parseInt(reduceMonths);
  return (
    new Date(
      dtTmp.getFullYear(),
      dtTmp.getMonth() - reduceMonths,
      dtTmp.getDate(),
      dtTmp.getHours(),
      dtTmp.getMinutes(),
      dtTmp.getSeconds()
    ).getTime() + 1000
  );
}

window.getMinusMonths = (endDate, minusMonths) => {
  let dtTmp = new Date(parseInt(endDate))
  minusMonths = parseInt(minusMonths)
  return new Date(dtTmp.getFullYear(), (dtTmp.getMonth()) - minusMonths, dtTmp.getDate(), dtTmp.getHours(), dtTmp.getMinutes(), dtTmp.getSeconds()).getTime()
}

window.getPlusDays = (startDate, plusDays) => {
  let dtTmp = new Date(parseInt(startDate))
  plusDays = parseInt(plusDays)
  return new Date(Date.parse(dtTmp) + 86400000 * plusDays).getTime()
}

window.getMinusDays = (endDate, minusDays) => {
  let dtTmp = new Date(parseInt(endDate))
  minusDays = parseInt(minusDays)
  return new Date(Date.parse(dtTmp) - (86400000 * minusDays)).getTime()
}

//判断课时是否为整数
window.deleteZero = classHour => {
  return new Number(classHour).valueOf()
}

//判断是否为两位小数
window.isNumber = str => {
  var regex = /^\d+\.?\d{0,2}$/
  return regex.test(str)
}

// 判断是否是数组且长度不为0
window.isLongArr = arr => {
  return Array.isArray(arr) && arr.length > 0
}

//判断是否为整数
window.isInteger = obj => {
  return obj % 1 === 0
}

// 判断是否为 >=0 的数字
window.isPositiveNum = num => {
  return isNumber(num) && Number(num) >= 0
}

/**
 * 通过课程类型 type 和 课时 得到正确的课时
 */
window.getCorrectClassHour = (type, classHour) => {
  if (type == 3) {
    return classHour
  } else if (type == 1 || type == 2) {
    return timeFormat(classHour)
  }
}

/**
 * 返回下一个需要刷新的页面索引
 * @param  number total        总数据量
 * @param  number current      当前页面
 * @param  number size         页面展示个数
 * @param  number deleteNumber 删除数量
 * @return number              需要刷新的页面
 */
window.nextReloadPageNumber = (total, current, size, deleteNumber) => {
  const currentTotal = total - deleteNumber
  const pageNumber = Math.max(parseInt(currentTotal - 1 / size), 0)
  return Math.min(pageNumber, current)
}

// 获取剩余天数,设置课程有效期之后启用
window.getLeftExpiredDay = (expiredDate, minWarningDays, onlyShowTimeover) => {
  const expiredDay = Math.floor(
    (Number(expiredDate) - Date.now()) / (24 * 60 * 60000)
  )
  let tempStr = '（剩余' + expiredDay + '天）'
  if (expiredDay <= 0) {
    tempStr = '（已到期）'
  }

  // 最小预警天数
  if (minWarningDays) {
    if (expiredDay > minWarningDays) {
      tempStr = ''
    }
  }

  if (onlyShowTimeover) {
    if (expiredDay > 0) {
      tempStr = ''
    }
  }

  return tempStr
}

// 处理月份
window.handleMonth = (num) => {
  var result = ''
  if (num < 12) {
    result = `${num}个月`
  } else {
    var year = Math.floor(num / 12)
    var month = num % 12
    if (!month) {
      result = `${year}年`
    } else {
      result = `${year}年${month}月`
    }
  }
  return result
}

// 检测是否为正确的手机号码
window.isValidPhone = phone => {
  // const tempPhone = Number(phone)
  return /^[0-9]{11}$/.test(phone)
}

window.timeFilter = time => {
  const timeUnit = 60
  let hour = Math.floor(time / timeUnit)
  let minute = time % timeUnit
  if (hour.toString().length == 1) {
    hour = '0' + hour
  }
  if (minute.toString().length == 1) {
    minute = '0' + minute
  }

  return hour + ':' + minute
}

window.getMinutesTime = date => {
  const hour = parseInt(date / 60)
  let mint = date - hour * 60
  mint > 10 ? (mint = mint) : (mint = '0' + mint)
  return hour + ':' + mint
}

// 冲突函数
window.clashFunction = data => {
  const returnData = {
    teachers: {},
    students: {},
    classRooms: {},
    classes: {}
  }
  Array.isArray(data) &&
    data.map(item => {
      Array.isArray(item.instScheduleClassConflictVOList) &&
        item.instScheduleClassConflictVOList.map(value => {
          value.type = item.conflictType
          if (item.conflictType == 1) {
            //老师
            if (!returnData.teachers[item.conflictName]) {
              returnData.teachers[item.conflictName] = []
            }
            value.teacherName = item.conflictName
            returnData.teachers[item.conflictName].push(value)
          } else if (item.conflictType == 2) {
            //学生
            if (!returnData.students[item.conflictName]) {
              returnData.students[item.conflictName] = []
            }
            value.studentName = item.conflictName
            returnData.students[item.conflictName].push(value)
          } else if (item.conflictType == 3) {
            //本班冲突
            if (!returnData.classRooms[item.conflictName]) {
              returnData.classRooms[item.conflictName] = []
            }
            value.classRoomName = item.conflictName
            returnData.classRooms[item.conflictName].push(value)
          } else if (item.conflictType == 4) {
            //班级冲突
            if (!returnData.classes[item.conflictName]) {
              returnData.classes[item.conflictName] = []
            }
            value.classesName = item.conflictName
            returnData.classes[item.conflictName].push(value)
          }
        })
    })
  returnData.students = _.values(returnData.students)
  returnData.teachers = _.values(returnData.teachers)
  returnData.classRooms = _.values(returnData.classRooms)
  returnData.classes = _.values(returnData.classes)
  return returnData
}

function checkClash(url, query) {
  let result = JSON.parse(axios.post(url, query, { sync: true }))
  let hasClash = 0
  if (result.data && result.data.constructor.name == 'Object') {
    result.data = [result.data][0]
  }
  let returnData = window.clashFunction(result.data)
  if (
    returnData.classRooms.length > 0 ||
    returnData.students.length > 0 ||
    returnData.teachers.length > 0
  ) {
    hasClash = returnData
  }
  if (typeof result == 'string') {
    result = JSON.parse(result)
  }
  result.hasClash = hasClash
  result.data = returnData
  return result
}

window.checkClash = checkClash

window.caluDateTimeStamp = (date, minute) => {
  let dateTimeStamp = date.startOf('day').valueOf()
  if (minute) {
    let minuteTimeStamp = parseInt(minute) * 60 * 1000
    return dateTimeStamp + minuteTimeStamp
  }
  return dateTimeStamp
}

window.hashFilter = hash => {
  if (!hash) {
    return '/'
  }
  hash.replace(/#/, '')
  let list = hash.split('/')
  list = _.filter(list, item => {
    return item && !/^[0-9]*$/.test(item)
  })
  return list.join('/')
}

window.getObjectURL = file => {
  var url = null
  if (window.createObjcectURL != undefined) {
    url = window.createOjcectURL(file)
  } else if (window.URL != undefined) {
    url = window.URL.createObjectURL(file)
  } else if (window.webkitURL != undefined) {
    url = window.webkitURL.createObjectURL(file)
  }
  return url
}

window.setNumberInput = (str, ret = 1) => {
  if (!str && !isNumber(str)) {
    return ''
  }
  return str / ret
}

window.getNumberInput = (str, ret = 1) => {
  str = str + ''
  if (!str && !isNumber(str)) {
    return ''
  }
  return str * ret
}

window.removeNull = function (param) {
  if (!param) {
    return
  }
  for (let attr in param) {
    if (_.isNull(param[attr]) || _.isUndefined(param[attr])) {
      delete param[attr]
      continue
    }
    if (
      typeof param[attr] == 'number' &&
      (param[attr] + '').indexOf('.9999') != -1
    ) {
      param[attr] = Math.round(param[attr])
    }
    if (typeof param[attr] == 'object') {
      removeNull(param[attr])
    }
  }
}

window.convertBase64ToBlob = function (base64) {
  var base64Arr = base64.split(',')
  var imgtype = ''
  var base64String = ''
  if (base64Arr.length > 1) {
    //如果是图片base64，去掉头信息
    base64String = base64Arr[1]
    imgtype = base64Arr[0].substring(
      base64Arr[0].indexOf(':') + 1,
      base64Arr[0].indexOf(';')
    )
  }
  // 将base64解码
  var bytes = atob(base64String)
  //var bytes = base64;
  var bytesCode = new ArrayBuffer(bytes.length)
  // 转换为类型化数组
  var byteArray = new Uint8Array(bytesCode)

  // 将base64转换为ascii码
  for (var i = 0; i < bytes.length; i++) {
    byteArray[i] = bytes.charCodeAt(i)
  }

  // 生成Blob对象（文件对象）
  return new Blob([bytesCode], { type: imgtype })
}

window.formatMsgCreateTime = function (createTime) {
  const newTime =
    moment().year() > moment(parseInt(createTime)).year()
      ? formatDate('YYYY-MM-DD H:i', parseInt(createTime))
      : moment().dayOfYear() - 1 > moment(parseInt(createTime)).dayOfYear()
        ? formatDate('MM-DD H:i', parseInt(createTime))
        : moment().dayOfYear() - 1 == moment(parseInt(createTime)).dayOfYear()
          ? '昨天 ' + formatDate('H:i', parseInt(createTime))
          : Math.floor((moment().valueOf() - parseInt(createTime)) / 1000 / 60) > 60
            ? '今天' + formatDate('H:i', parseInt(createTime))
            : Math.floor((moment().valueOf() - parseInt(createTime)) / 1000 / 60) > 1
              ? Math.floor((moment().valueOf() - parseInt(createTime)) / 1000 / 60) +
              '分钟前'
              : '刚刚'
  return newTime
}

window.getBase64Img = (url, size = 500) => {
  let img = document.getElementById('xm_img_div')
  if (img) {
    img.remove()
  }

  return new Promise((resolve, reject) => {
    if (!url) {
      resolve('')
    }
    url = url.replace(/http:/, "https:") + `?x-oss-process=image/resize,h_${size},w_${size}`;
    img = document.createElement("div");
    img.style.position = "fixed";
    img.style.left = "-10000px";
    img.id = "xm_img_div";
    img.innerHTML = `<img id='xm_img_url'  src=${url} />`;
    document.body.appendChild(img);
    setTimeout(() => {
      let node = document.getElementById('xm_img_url')
      domtoimage.toPng(node).then(imgData => {
        resolve(imgData)
      })
    }, 2000)
  })
}

window.getDateStr = timeStamp => {
  const date = new Date(timeStamp)
  const year = date.getFullYear()
  let month = date.getMonth() + 1
  let day = date.getDate()

  if (month < 10) {
    month = `0${month}`
  }
  if (day < 10) {
    day = `0${day}`
  }
  return `${year}${month}${day}`
}

window.copyText = textContent => {
  const inputDom = document.createElement('textarea')

  inputDom.value = textContent
  document.body.appendChild(inputDom)
  inputDom.select()
  document.execCommand('copy')
  document.body.removeChild(inputDom)
}

window.downloadFile = (dataURL, fileName) => {
  const blob = window.convertBase64ToBlob(dataURL)
  const href = window.getObjectURL(blob)

  window.download(href, fileName);
}

window.getCouponRule = record => {
  const {
    type,
    couponType,
    consumeAmount,
    discount,
    classHour,
    giftName
  } = record
  let rule = ''

  switch (type || couponType) {
    case 1:
      if (consumeAmount) {
        rule = `满${consumeAmount / 100}可用`
      }
      break
    case 2:
      rule = `${discount / 10}折`
      break
    case 3:
      rule = `${classHour / 100}课时`
      break
    case 4:
      rule = giftName
      break
    default:
      break
  }
  return rule
}

window.getCouponRuleNew = record => {
  const {
    type,
    couponType,
    consumeAmount,
    decimalDiscountAmount,
    discount,
    classHour,
    giftName
  } = record
  let rule = ''

  switch (couponType) {
    case 'CASH':
      rule = `抵扣${decimalDiscountAmount}元`
      break
    case 'DISCOUNT':
      rule = `${discount / 10}折`
      break
    case 'CLASS_HOUR':
      rule = `${classHour / 100}课时`
      break
    case 'GIFT':
      rule = giftName
      break
    default:
      break
  }
  return rule
}

window.replaceString = str => {
  return str.replace(/\n/g, '<br/>')
}

/**
  处理换行字符
 */
window.replaceStringReverse = str => {
  return str.replace(/<br\/>/g, '\n')
}

// 判断是否是腾讯视频
window.isTencentVideo = url => {
  const TENCENT_FLAG = 'v.qq.com'
  return url.indexOf(TENCENT_FLAG) >= 0
}

// 判断是否是优酷视频
window.isYoukuVideo = url => {
  const YOUKU_FLAG = 'v.youku.com'
  return url.indexOf(YOUKU_FLAG) >= 0
}

// 手机号中间4位星号处理
window.starPhone = (phone) => {
  let newPhone = ''
  if (phone) {
    newPhone = phone.substr(0, 3) + '****' + phone.substr(7)
  }
  return newPhone
}

// 人民币格式 单位元
window.getMoneyFormatYuan = (price) => {
  if (!_.isNumber(Number(price))) {
    return '0.00'
  }
  const n = parseFloat(price).toFixed(2)
  const re = /(\d{1,3})(?=(\d{3})+(?:\.))/g
  return n.replace(re, '$1,')
}

// 处理定价标准 仅订单详情，打印收据预览可用
window.formatPriceStandard = (info) => {
  let { quantityUnit, specName, commoditySpecs, purchaseItemType, unitPriceAfterDiscount, specCurrentPrice } = info
  let newCommoditySpecs = JSON.parse(commoditySpecs || '[]') || {}
  let { containQuantity, unitPrice, measurementUnits } = newCommoditySpecs
  let content = ''
  if (purchaseItemType != 'COURSE') {
    content = `${specCurrentPrice}元/${ENUM.itemUnit[quantityUnit]}`
  } else {
    let text = containQuantity != 1 ? containQuantity : '/'
    content = `${specName}(${specCurrentPrice}元${text}${measurementUnits})`
  }
  return content
}

window.getCouponRuleNew = (record) => {
  const { type, couponType, consumeAmount, decimalDiscountAmount, discount, classHour, giftName } = record
  let rule = ''

  switch (couponType) {
    case 'CASH':
      rule = `抵扣${decimalDiscountAmount}元`
      break
    case 'DISCOUNT':
      rule = `${discount / 10}折`
      break
    case 'CLASS_HOUR':
      rule = `${classHour / 100}课时`
      break
    case 'GIFT':
      rule = giftName
      break
    default: break
  }
  return rule
}

window.renderCourseName = (list) => {
  if (list && list.length) {
    const associatedCourseList = JSON.parse(JSON.stringify(list))
    const length = associatedCourseList.length
    const majorCourseIndex = associatedCourseList.findIndex((item) => item.major === 'YES')
    const majorCourse = associatedCourseList.splice(majorCourseIndex, 1)[0]
    const content = (
      <div className="course-content">
        <p><i className="icon iconfont icon-zhu"></i>{majorCourse.name}</p>
        {
          associatedCourseList.map((item, index) => {
            return <p><i className="icon iconfont icon-ci"></i>{item.name}</p>
          })
        }
      </div>
    )

    return length > 1 ?
      <span>{majorCourse.name}
        <Popover placement="bottomLeft" content={content} arrowPointAtCenter>
          等<span style={{ color: '#FF7519', cursor: 'pointer' }}>{length}</span>门
        </Popover>
      </span> :
      <span>{majorCourse.name}</span>
  }

  return ''
}

window.convertBase64UrlToBlob = (urlData) => {
  const bytes = window.atob(urlData.split(",")[1]);
  const ab = new ArrayBuffer(bytes.length);
  const ia = new Uint8Array(ab);
  for (let i = 0; i < bytes.length; i++) {
    ia[i] = bytes.charCodeAt(i);
  }
  return new Blob([ab], { type: "image/png" });
}

// 小麦秀 new 标签显示
window.XMShowClassName = (date, itemName) => {
  // 超过时间不显示
  if (new Date().getTime() > date) {
    return '';
  }
  // 用户点击相应区域后不显示
  if (localStorage.getItem(itemName) === 'true') {
    return '';
  }
  return 'new-icon'
}