import React from 'react'
import './Main.less';
import Bus from "@/core/bus";
import { MainRoutes } from '@/routes';
class Main extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      menuType: 1,
    }
  }
  componentDidMount() {
    console.log("MainRoutes",MainRoutes);
    Bus.bind("menuTypeChange", (menuType) => {
      this.setState({ menuType })
    });
  }
  render() {
    const { hasBanner } = this.props;
    return (
      <div
        className={this.state.menuType ? `right-container has-nav ${hasBanner ? 'has_banner' : ''}` : `right-container has-nav right-container-vertical ${hasBanner ? 'has_banner' : ''}`}
        id="rightContainer"
      >
        <MainRoutes/>
      </div>
    )
  }
}

export default Main;
