import React, { useState, useEffect } from 'react';
import Breadcrumbs from '@/components/Breadcrumbs';
import WechatUserAuditFilter from './WechatUserAuditFilter';
import WechatUserAuditOpt from './WechatUserAuditOpt'
import WechatUserAuditList from './WechatUserAuditList';
import StoreService from "@/domains/store-domain/storeService";
import User from '@/common/js/user';

import './WechatUserAudit.less';
const WechatUserAudit = function () {
  const [listData, setListData] = useState([]);
  const [totalCount, setTotalCount] = useState(0);
  const [listCount, setListCount] = useState({
    "allCnt": 0,
    "passedCnt": 0,
    "rejectedCnt": 0,
    "waitCnt": 0
  });
  const [query, setQuery] = useState({
    current: 1,
    size: 10,
    applyStatus: 'WAIT'  //PASSED, WAIT, REJECTED 
  });

  useEffect(() => {
    
    //列表获取
    function handleFetchAuditList(_query) {
      const params = {
        ...query,
        ..._query,
        storeId: User.getStoreId(),
      };
    
      StoreService.getCustomerAuditList(params).then((res) => {
        const {
          result: { records = [], total },
        } = res;
        setListData(records);
        setTotalCount(total);
      });
    }
    //列表获取
    function handleFetchAuditListCount(_query) {
      const params = {
        storeId: User.getStoreId(),
      };
    
      StoreService.getCustomerAuditListCount(params).then((res) => {
        const {
          result,
        } = res;
        setListCount(result)
      });
    }

    handleFetchAuditList();
    handleFetchAuditListCount();

  }, [query]);

  //搜索条件改变
  function queryChange(_query) {
    if(_query.applyStatus===''){
      _query.applyStatus = null
    }
    const params = {
      ...query,
      ..._query,
    };
    setQuery(params);
  }

  return (
    <div className='page wechat-user-audit'>
      <Breadcrumbs navList='学员审核列表' />
      <div className='box'>
        <WechatUserAuditFilter onChange={queryChange} />
        <WechatUserAuditOpt onChange = {queryChange} listCount={listCount} defaultType={query.applyStatus}/>
       <WechatUserAuditList listData={listData} query={query} totalCount={totalCount} onChange={queryChange} />
      </div>
    </div>
  );
};
export default WechatUserAudit;
