/*
 * @Description:
 * @Author: zangsuyun
 * @Date: 2021-03-12 14:25:52
 * @LastEditors: zangsuyun
 * @LastEditTime: 2021-04-10 11:23:08
 * @Copyright: © 2020 杭州杰竞科技有限公司 版权所有
 */

import React, { useState, useEffect } from "react";

import { Button, Menu, Dropdown,message } from "antd";
import SelectPrepareFileModal from "@/modules/prepare-lesson/modal/SelectPrepareFileModal";
import { DownOutlined } from "@ant-design/icons";
import AddCourse from "../modal/AddCourse";
import User from "@/common/js/user";
import KnowledgeAPI from "@/data-source/knowledge/request-api";

export default function KnowledgeBaseOpt({
  categoryId,
  updateCategoryTree,
  onChange,
}) {
  const [modal, setModal] = useState(null);

  const menu = (
    <Menu>
      <Menu.Item key="1" style={{ textAlign: "center" }}>
        <span onClick={handAddCourse}>添加课程</span>
      </Menu.Item>
      <Menu.Item key="2" style={{ textAlign: "center" }}>
        <span onClick={handleAddFile}>添加资料</span>
      </Menu.Item>
    </Menu>
  );

  function handAddCourse() {
    let modal = (
      <AddCourse
        onClose={() => {
          setModal(null);
        }}
        onChange={onChange}
        categoryId={categoryId}
        updateCategoryTree={updateCategoryTree}
      ></AddCourse>
    );
    setModal(modal);
  }

  function handUpload(refIds) {
    const params = {
      categoryId: categoryId,
      refIds,
      storeId: User.getStoreId(),
      createId: User.getStoreUserId(),
      type: "FOLDER",
    };
    KnowledgeAPI.addKnowledge(params).then(({ success }) => {
      if (success) {
        message.success("新增成功");
        onChange();
        updateCategoryTree();
        setModal(null);
      }
    });
    setModal(null);
  }

  function handleAddFile() {
    let modal = (
      <SelectPrepareFileModal
        multiple={true}
        scene="knowledge"
        operateType="select"
        isOpen={true}
        accept=".ppt,.pptx,.doc,.docx,.pdf,.jpg,.jpeg,.png,.xlsx,.xls"
        tooltip="支持文件类型：ppt、word、excel、pdf、jpg、jpeg、png"
        selectTypeList={["JPG", "JPEG", "PNG",'DOC','PDF','EXCEL','application/msword','application/vnd.ms-powerpoint']} // DOC 包含 .pptx,.docx,.xls.XLSX,WORD:DOC
        onClose={() => {
          setModal(null);
        }}
        onSelect={handUpload}
      />
    );
    setModal(modal);
  }

  return (
    <div className="video-course-opt">
      <Dropdown overlay={menu}>
        <Button type="primary" className="mr12">
          添加知识
          <DownOutlined />
        </Button>
      </Dropdown>

      {modal}
    </div>
  );
}
