import React, { useState, useRef, useEffect, useContext } from 'react'
import Breadcrumbs from "@/components/Breadcrumbs";
import { Form, Alert, Input, Button } from 'antd';
import { Route, withRouter } from 'react-router-dom';
import SelectPaperModal from './SelectPaperModal'
import './AddExam.less';

function AddExam(props: any) {

    const [showModal, setShowModal] = useState(false)

    return <div className="page examPage">
        <Breadcrumbs navList={"新建考试"} goBack={() => props.history.goBack()} />

        <div className="box">
            <Alert message="请遵守国家相关规定，切勿上传低俗色情、暴力恐怖、谣言诈骗、侵权盗版等相关内容，小麦企培保有依据国家规定及平台规则进行处理的权利" type="info" showIcon />
            <div className="form">
                <div className="title">基本信息</div>
                <Form
                    labelCol={{ span: 3 }}
                    wrapperCol={{ span: 14 }}
                    layout="horizontal"
                >
                    <Form.Item label="考试名称" name="size" required>
                        <Input placeholder='请输入试卷名称（40字以内）' style={{ width: 300 }} />
                    </Form.Item>

                    <Form.Item label="选择试卷" name="size" required>
                        <Button onClick={()=>{setShowModal(true)}} >选择试卷</Button>
                    </Form.Item>



                </Form>
            </div>

        </div>
        {
            showModal && <SelectPaperModal></SelectPaperModal>
        }

    </div>
}


export default withRouter(AddExam);