import React, { useEffect, useState } from 'react';
import { withRouter } from "react-router-dom";
import { PageControl, XMTable } from '@/components';
import Service from '@/common/js/service';
import User from '@/common/js/user';


function ExamTable(props: any) {
    const [query, setQuery] = useState<any>({
        current: 1, size: 10,
        taskId: props.taskId,
        source: 0,
        tenantId: User.getStoreId(),
        userId: User.getStoreUserId(),
    });
    const [list, setList] = useState<any[]>([]);
    const [total, setTotal] = useState<any>(0);

    useEffect(() => {
        getList()
    }, [query])

    function getList() {
        Service.Hades('public/hades/queryTrainingExamUserData', query).then((res: any) => {
            setList(res.result.records)
            setTotal(res.result.tatal)
        })
    }


    const columns = [
        {
            title: '考试名称',
            key: 'examName',
            dataIndex: 'examName',

        },
        {
            title: '完成人数',
            key: 'finishCnt',
            dataIndex: 'finishCnt',

        },
        {
            title: '平均分',
            key: 'averageScore',
            dataIndex: 'averageScore',
            render: (val: any, record: any) => {

                return <div>{val || 0}</div>;
            },

        },
        {
            title: '及格人数',
            key: 'passCnt',
            dataIndex: 'passCnt',
            render: (val: any, record: any) => {

                return <div>{val || 0}</div>;
            },
        },
        {
            title: '及格率',
            key: 'passPercentage',
            dataIndex: 'passPercentage',
            render: (val: any, record: any) => {

                return <div>{val}%</div>;
            },
        },



        {
            title: '操作',
            key: 'operate',
            dataIndex: 'operate',
            render: (val: any, record: any) => {
                return (
                    <div className='operate-area'>
                        <span className='operate-item' onClick={() => { }}>
                            查看数据
                        </span>

                    </div>
                );
            },
        },
    ];


    return <div className="study_Table">

        <div style={{ marginTop: 12 }}>
            <XMTable
                renderEmpty={{
                    type: 'college',
                    description: '暂无数据',
                }}
                rowKey={(record: any) => record.storeCustomerId}
                dataSource={list}
                columns={columns}
                pagination={false}
                className='user-learning-table'
                onChange={() => { }}
                showSorterTooltip={false}
                bordered
            />
            {list.length > 0 && (
                <div className='box-footer'>
                    <PageControl
                        current={query.current - 1}
                        pageSize={query.size}
                        total={total}
                        toPage={(page: any) => {
                            setQuery({ ...query, current: query.current + 1 })
                        }}

                    />
                </div>
            )}
        </div>

    </div>
}

export default withRouter(ExamTable)